package com.els.base.company;

import java.util.ArrayList;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

/**
 * 模块描述
 * @author hzy
 *
 */
@Configuration("companyModuleDescription")
public class ModuleDescription {
	
	@Bean("companyApi")
	public Docket companyApi() {
		ApiInfo apiInfo = new ApiInfo(
				"企业信息模块", 
				"该模块用于管理，企业信息，企业之间的关系与角色，企业与用户的信息", 
				"2.0.0-SNAPSHOT", 
				"",
				new Contact("hzy", "", "huangzhiyong@51qqt.com"),
				"无", "无", new ArrayList<>());
		
		Docket docket = new Docket(DocumentationType.SWAGGER_2)
			.groupName("company")
			.select()
			.apis(RequestHandlerSelectors.basePackage("com.els.base.company"))
	        .build()
	        .apiInfo(apiInfo);
		
		return docket;
	}

}
