package com.els.base.company.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.els.base.core.entity.user.User;
import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.els.base.utils.json.IgnoreDeserialzer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "供应商主数据")
public class Company implements Serializable {

	// ##########以下非自动生成，请勿覆盖###########

	@JsonDeserialize(using = IgnoreDeserialzer.class)
	private Map<String, Object> extInfo;

	public Map<String, Object> getExtInfo() {
		return extInfo;
	}

	public void setExtInfo(Map<String, Object> extInfo) {
		this.extInfo = extInfo;
	}

	private String password;// 供应商注册密码

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	@JsonDeserialize(using = IgnoreDeserialzer.class)
	private List<User> userList;

	public List<User> getUserList() {
		return userList;
	}

	public void setUserList(List<User> userList) {
		this.userList = userList;
	}

	List<CompanyAddress> companyAddressList;

	public List<CompanyAddress> getCompanyAddressList() {
		return companyAddressList;
	}

	public void setCompanyAddressList(List<CompanyAddress> companyAddressList) {
		this.companyAddressList = companyAddressList;
	}

	// ##########非自动生成，请勿覆盖##########

	@ApiModelProperty("主键")
	private String id;

    @ApiModelProperty("上级主键")
    private String parentId;

    @ApiModelProperty("所在项目id")
    private String projectId;

    @ApiModelProperty("行业大类")
    private String industry;

    @ApiModelProperty("行业小类")
    private String subIndustry;

    @ApiModelProperty("公司代码")
    private String companyCode;

    @ApiModelProperty("公司sap编码")
    private String companySapCode;

    @ApiModelProperty("公司简称")
    private String companyName;

    @ApiModelProperty("公司全称")
    private String companyFullName;

    @ApiModelProperty("公司性质")
    private String companyType;

    @ApiModelProperty("公司业务范围")
    private String businessScop;

    @ApiModelProperty("税务登记证")
    private String taxCert;

    @ApiModelProperty("组织架构证")
    private String organzationCert;

    @ApiModelProperty("营业执照")
    private String businessLicence;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省份")
    private String province;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("详细地址")
    private String address;

    @ApiModelProperty("移动电话")
    private String mobilephone;

    @ApiModelProperty("固定电话")
    private String telephone;

    @ApiModelProperty("传真")
    private String fax;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("网站")
    private String website;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("联系人")
    private String contacts;

    @ApiModelProperty("状态：待审核100;已审核200;")
    private Integer status;

    @ApiModelProperty("是否可用，0不可用，1可用")
    private Integer isEnable;

    @ApiModelProperty("外部制造商(1=内购,2=转厂,3=交香港)")
    private String externalManufacturer;

    @ApiModelProperty("采购员")
    private String purchasingStaff;

    @ApiModelProperty("科目组")
    private String groupCode;

    @ApiModelProperty("代表类型（代理商，制造商，贸易商）")
    private String delegateType;

    @ApiModelProperty("业务类型")
    private String businessType;

    @ApiModelProperty("工业类型")
    private String industrialType;

    @ApiModelProperty("统驭科目code")
    private String reconciliationAccountCode;

    @ApiModelProperty("统驭科目描述")
    private String reconciliationAccountName;

    @ApiModelProperty("付款条件code")
    private String payConditionsCode;

    @ApiModelProperty("付款条件描述")
    private String payConditionsDesc;

    @ApiModelProperty("订单货币")
    private String orderCurren;

    @ApiModelProperty("国际贸易条件")
    private String internationalTradeCondition;

    @ApiModelProperty("销售员")
    private String salesman;

    @ApiModelProperty("销售员电话")
    private String salesmanPhone;

    @ApiModelProperty("基于收货的发票验证")
    private String invoiceVerify;

    @ApiModelProperty("自动建立采购订单")
    private String automaticPurchaseOrder;

    @ApiModelProperty("采购组")
    private String purchasingGroup;

    @ApiModelProperty("计划交付时间(天数）")
    private String plannedDeliveryTime;

    @ApiModelProperty("供应属性")
    private String supplyProperties;

    @ApiModelProperty("行业类型编码")
    private String industryCode;

    @ApiModelProperty("行业类型描述")
    private String industryDesc;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("开户银行")
    private String bankName;

    @ApiModelProperty("开户银行地址")
    private String bankAddress;

    @ApiModelProperty("供应商银行账号")
    private String bankAccount;

    @ApiModelProperty("公司法人")
    private String corporationLegalPerson;

    @ApiModelProperty("供应商服务类")
    private String firstCompanyType;

    @ApiModelProperty("产品大类")
    private String secondCompanyType;

    @ApiModelProperty("企业英文名称")
    private String englishCompanyName;

    @ApiModelProperty("英文地址")
    private String englishAddress;

    @ApiModelProperty("注册资本")
    private String registeredCapital;

    @ApiModelProperty("代理品牌")
    private String actingBrand;

    @ApiModelProperty("公司成立时间")
    private Date companyEstablishmentTime;

    @ApiModelProperty("工作场所所有权")
    private String workplaceOwnership;

    @ApiModelProperty("厂房使用率")
    private String plantUseRate;

    @ApiModelProperty("产品供货周期")
    private String productSupplyCycle;

    @ApiModelProperty("BD反馈时间")
    private String feedbackTime;

    @ApiModelProperty("PPM表现")
    private String ppmPerformance;

    @ApiModelProperty("代理证时间")
    private Date agentTime;

    @ApiModelProperty("代理产品")
    private String actingProducts;

    @ApiModelProperty("交货方式")
    private String deliveryMode;

    @ApiModelProperty("是否提供现场服务(1提供,0不提供)")
    private Integer isFieldService;

    @ApiModelProperty("营业执照注册号")
    private String businessLicenseNumber;

    @ApiModelProperty("资本类型")
    private String capitalType;

    @ApiModelProperty("公司英文简称")
    private String companyEnglishAbbreviation;

    @ApiModelProperty("完成标识符(0=未完成，1=已完成)")
    private Integer finishFlag;

    @ApiModelProperty("公司主营大类型说明")
    private String firstCompanyTypeExplain;

    @ApiModelProperty("公司主营二类型说明")
    private String secondCompanyTypeExplain;

    @ApiModelProperty("竞投类产品")
    private String competitionProducts;

    @ApiModelProperty("审核状态")
    private Integer approveStatus;

    @ApiModelProperty("审核人")
    private String approveUserName;

    @ApiModelProperty("审核时间")
    private Date approveTime;

    @ApiModelProperty("经营范围")
    private String businessScope;

    @ApiModelProperty("生产地址")
    private String productionAddress;

    @ApiModelProperty("占地面积")
    private BigDecimal landArea;

    @ApiModelProperty("总建筑面积")
    private BigDecimal totalBuildingArea;

    @ApiModelProperty("厂房面积")
    private BigDecimal plantArea;

    @ApiModelProperty("管理人员数")
    private Integer managerNumber;

    @ApiModelProperty("业务人员数")
    private Integer salesmanNumber;

    @ApiModelProperty("工程技术人员数")
    private Integer technicianNumber;

    @ApiModelProperty("质量人员数")
    private Integer qualityInspectorNumber;

    @ApiModelProperty("工人数")
    private Integer workerNumber;

    @ApiModelProperty("总人数")
    private Integer totalNumber;

    @ApiModelProperty("产品产能")
    private BigDecimal productCapacity;

    @ApiModelProperty("分类3")
    private String classificationThree;

    @ApiModelProperty("等级")
    private String grade;

    @ApiModelProperty("月产能")
    private BigDecimal monthlyCapacity;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("供应商检索项")
    private String companyRetrieve;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("外包过程")
    private String outsourcingProcess;

    @ApiModelProperty("联行号")
    private String coupletNumber;

    @ApiModelProperty("企业获奖情况")
    private String awardSituation;

    @ApiModelProperty("产品/过程/服务及类型")
    private String productType;

    @ApiModelProperty("供应商分类id")
    private String categoryId;

    @ApiModelProperty("供应商分类编码")
    private String categoryCode;

    @ApiModelProperty("供应商分类名称")
    private String categoryName;

    @ApiModelProperty("采购周期")
    private String purchaseCycle;

    @ApiModelProperty("汽车类业务比例")
    private String carBusinessProportion;

    @ApiModelProperty("运输方式")
    private String transportType;

    @ApiModelProperty("运输占产品比重")
    private String transportProProportion;

    @ApiModelProperty("包装占产品比重")
    private String packingProProportion;

    @ApiModelProperty("付款账期")
    private String paymentPeriod;

    @ApiModelProperty("交货方式描述")
    private String deliveryModeDesc;

    @ApiModelProperty("运输方式描述")
    private String transportTypeDesc;

    @ApiModelProperty("币别描述")
    private String orderCurrenDesc;

    @ApiModelProperty("付款账期描述")
    private String paymentPeriodDesc;

    @ApiModelProperty("服务类别")
    private String serviceCategory;

    @ApiModelProperty("产品重要度ID")
    private String productImportanceId;

    @ApiModelProperty("产品重要度")
    private String productImportanceName;

    @ApiModelProperty("合作关系ID")
    private String symbiosisId;

    @ApiModelProperty("合作关系")
    private String symbiosis;

    @ApiModelProperty("关键程度ID")
    private String criticalityId;

    @ApiModelProperty("关键程度")
    private String criticalityName;
    
    @ApiModelProperty("是否上线SRM")
    private Integer isOnline;

    @ApiModelProperty("备用字段1")
    private String attribute1;

    @ApiModelProperty("备用字段2")
    private String attribute2;

    @ApiModelProperty("备用字段3")
    private String attribute3;

    @ApiModelProperty("备用字段4")
    private String attribute4;

    @ApiModelProperty("备用字段5")
    private String attribute5;

    @ApiModelProperty("标注使用部门")
    private String useDept;

    @ApiModelProperty("何种类型供应商")
    private String supplierType;

    @ApiModelProperty("框架协议号")
    private String frameworkAgreeNum;

    @ApiModelProperty("框架协议是否签订(0:未签订，1：已签订)")
    private String frameworkIsSigned;

    @ApiModelProperty("质保金")
    private String retentionMoney;

    @ApiModelProperty("是否有质保金(0：无，1：有)")
    private String existRetentionMoney;

//    @JsonSerialize(using=UploadSupportJsonSerializer.class)
//    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("KN管理资料附件")
    private String knMngFiles;

    @ApiModelProperty("KN管理资料备注")
    private String knMngRemark;

    private static final long serialVersionUID = 1L;

    public String getKnMngFiles() {
        return knMngFiles;
    }

    public void setKnMngFiles(String knMngFiles) {
        this.knMngFiles = knMngFiles;
    }

    public String getKnMngRemark() {
        return knMngRemark;
    }

    public void setKnMngRemark(String knMngRemark) {
        this.knMngRemark = knMngRemark;
    }

    public String getFrameworkAgreeNum() {
        return frameworkAgreeNum;
    }

    public void setFrameworkAgreeNum(String frameworkAgreeNum) {
        this.frameworkAgreeNum = frameworkAgreeNum;
    }

    public String getFrameworkIsSigned() {
        return frameworkIsSigned;
    }

    public void setFrameworkIsSigned(String frameworkIsSigned) {
        this.frameworkIsSigned = frameworkIsSigned;
    }

    public String getRetentionMoney() {
        return retentionMoney;
    }

    public void setRetentionMoney(String retentionMoney) {
        this.retentionMoney = retentionMoney;
    }

    public String getExistRetentionMoney() {
        return existRetentionMoney;
    }

    public void setExistRetentionMoney(String existRetentionMoney) {
        this.existRetentionMoney = existRetentionMoney;
    }

    public String getUseDept() {
        return useDept;
    }

    public void setUseDept(String useDept) {
        this.useDept = useDept;
    }

    public String getSupplierType() {
        return supplierType;
    }

    public void setSupplierType(String supplierType) {
        this.supplierType = supplierType;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId == null ? null : parentId.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry == null ? null : industry.trim();
    }

    public String getSubIndustry() {
        return subIndustry;
    }

    public void setSubIndustry(String subIndustry) {
        this.subIndustry = subIndustry == null ? null : subIndustry.trim();
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode == null ? null : companyCode.trim();
    }

    public String getCompanySapCode() {
        return companySapCode;
    }

    public void setCompanySapCode(String companySapCode) {
        this.companySapCode = companySapCode == null ? null : companySapCode.trim();
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }

    public String getCompanyFullName() {
        return companyFullName;
    }

    public void setCompanyFullName(String companyFullName) {
        this.companyFullName = companyFullName == null ? null : companyFullName.trim();
    }

    public String getCompanyType() {
        return companyType;
    }

    public void setCompanyType(String companyType) {
        this.companyType = companyType == null ? null : companyType.trim();
    }

    public String getBusinessScop() {
        return businessScop;
    }

    public void setBusinessScop(String businessScop) {
        this.businessScop = businessScop == null ? null : businessScop.trim();
    }

    public String getTaxCert() {
        return taxCert;
    }

    public void setTaxCert(String taxCert) {
        this.taxCert = taxCert == null ? null : taxCert.trim();
    }

    public String getOrganzationCert() {
        return organzationCert;
    }

    public void setOrganzationCert(String organzationCert) {
        this.organzationCert = organzationCert == null ? null : organzationCert.trim();
    }

    public String getBusinessLicence() {
        return businessLicence;
    }

    public void setBusinessLicence(String businessLicence) {
        this.businessLicence = businessLicence == null ? null : businessLicence.trim();
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country == null ? null : country.trim();
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province == null ? null : province.trim();
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city == null ? null : city.trim();
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    public String getMobilephone() {
        return mobilephone;
    }

    public void setMobilephone(String mobilephone) {
        this.mobilephone = mobilephone == null ? null : mobilephone.trim();
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone == null ? null : telephone.trim();
    }

    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax == null ? null : fax.trim();
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email == null ? null : email.trim();
    }

    public String getWebsite() {
        return website;
    }

    public void setWebsite(String website) {
        this.website = website == null ? null : website.trim();
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getContacts() {
        return contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts == null ? null : contacts.trim();
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getExternalManufacturer() {
        return externalManufacturer;
    }

    public void setExternalManufacturer(String externalManufacturer) {
        this.externalManufacturer = externalManufacturer == null ? null : externalManufacturer.trim();
    }

    public String getPurchasingStaff() {
        return purchasingStaff;
    }

    public void setPurchasingStaff(String purchasingStaff) {
        this.purchasingStaff = purchasingStaff == null ? null : purchasingStaff.trim();
    }

    public String getGroupCode() {
        return groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode == null ? null : groupCode.trim();
    }

    public String getDelegateType() {
        return delegateType;
    }

    public void setDelegateType(String delegateType) {
        this.delegateType = delegateType == null ? null : delegateType.trim();
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType == null ? null : businessType.trim();
    }

    public String getIndustrialType() {
        return industrialType;
    }

    public void setIndustrialType(String industrialType) {
        this.industrialType = industrialType == null ? null : industrialType.trim();
    }

    public String getReconciliationAccountCode() {
        return reconciliationAccountCode;
    }

    public void setReconciliationAccountCode(String reconciliationAccountCode) {
        this.reconciliationAccountCode = reconciliationAccountCode == null ? null : reconciliationAccountCode.trim();
    }

    public String getReconciliationAccountName() {
        return reconciliationAccountName;
    }

    public void setReconciliationAccountName(String reconciliationAccountName) {
        this.reconciliationAccountName = reconciliationAccountName == null ? null : reconciliationAccountName.trim();
    }

    public String getPayConditionsCode() {
        return payConditionsCode;
    }

    public void setPayConditionsCode(String payConditionsCode) {
        this.payConditionsCode = payConditionsCode == null ? null : payConditionsCode.trim();
    }

    public String getPayConditionsDesc() {
        return payConditionsDesc;
    }

    public void setPayConditionsDesc(String payConditionsDesc) {
        this.payConditionsDesc = payConditionsDesc == null ? null : payConditionsDesc.trim();
    }

    public String getOrderCurren() {
        return orderCurren;
    }

    public void setOrderCurren(String orderCurren) {
        this.orderCurren = orderCurren == null ? null : orderCurren.trim();
    }

    public String getInternationalTradeCondition() {
        return internationalTradeCondition;
    }

    public void setInternationalTradeCondition(String internationalTradeCondition) {
        this.internationalTradeCondition = internationalTradeCondition == null ? null : internationalTradeCondition.trim();
    }

    public String getSalesman() {
        return salesman;
    }

    public void setSalesman(String salesman) {
        this.salesman = salesman == null ? null : salesman.trim();
    }

    public String getSalesmanPhone() {
        return salesmanPhone;
    }

    public void setSalesmanPhone(String salesmanPhone) {
        this.salesmanPhone = salesmanPhone == null ? null : salesmanPhone.trim();
    }

    public String getInvoiceVerify() {
        return invoiceVerify;
    }

    public void setInvoiceVerify(String invoiceVerify) {
        this.invoiceVerify = invoiceVerify == null ? null : invoiceVerify.trim();
    }

    public String getAutomaticPurchaseOrder() {
        return automaticPurchaseOrder;
    }

    public void setAutomaticPurchaseOrder(String automaticPurchaseOrder) {
        this.automaticPurchaseOrder = automaticPurchaseOrder == null ? null : automaticPurchaseOrder.trim();
    }

    public String getPurchasingGroup() {
        return purchasingGroup;
    }

    public void setPurchasingGroup(String purchasingGroup) {
        this.purchasingGroup = purchasingGroup == null ? null : purchasingGroup.trim();
    }

    public String getPlannedDeliveryTime() {
        return plannedDeliveryTime;
    }

    public void setPlannedDeliveryTime(String plannedDeliveryTime) {
        this.plannedDeliveryTime = plannedDeliveryTime == null ? null : plannedDeliveryTime.trim();
    }

    public String getSupplyProperties() {
        return supplyProperties;
    }

    public void setSupplyProperties(String supplyProperties) {
        this.supplyProperties = supplyProperties == null ? null : supplyProperties.trim();
    }

    public String getIndustryCode() {
        return industryCode;
    }

    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode == null ? null : industryCode.trim();
    }

    public String getIndustryDesc() {
        return industryDesc;
    }

    public void setIndustryDesc(String industryDesc) {
        this.industryDesc = industryDesc == null ? null : industryDesc.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName == null ? null : bankName.trim();
    }

    public String getBankAddress() {
        return bankAddress;
    }

    public void setBankAddress(String bankAddress) {
        this.bankAddress = bankAddress == null ? null : bankAddress.trim();
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount == null ? null : bankAccount.trim();
    }

    public String getCorporationLegalPerson() {
        return corporationLegalPerson;
    }

    public void setCorporationLegalPerson(String corporationLegalPerson) {
        this.corporationLegalPerson = corporationLegalPerson == null ? null : corporationLegalPerson.trim();
    }

    public String getFirstCompanyType() {
        return firstCompanyType;
    }

    public void setFirstCompanyType(String firstCompanyType) {
        this.firstCompanyType = firstCompanyType == null ? null : firstCompanyType.trim();
    }

    public String getSecondCompanyType() {
        return secondCompanyType;
    }

    public void setSecondCompanyType(String secondCompanyType) {
        this.secondCompanyType = secondCompanyType == null ? null : secondCompanyType.trim();
    }

    public String getEnglishCompanyName() {
        return englishCompanyName;
    }

    public void setEnglishCompanyName(String englishCompanyName) {
        this.englishCompanyName = englishCompanyName == null ? null : englishCompanyName.trim();
    }

    public String getEnglishAddress() {
        return englishAddress;
    }

    public void setEnglishAddress(String englishAddress) {
        this.englishAddress = englishAddress == null ? null : englishAddress.trim();
    }

    public String getRegisteredCapital() {
        return registeredCapital;
    }

    public void setRegisteredCapital(String registeredCapital) {
        this.registeredCapital = registeredCapital == null ? null : registeredCapital.trim();
    }

    public String getActingBrand() {
        return actingBrand;
    }

    public void setActingBrand(String actingBrand) {
        this.actingBrand = actingBrand == null ? null : actingBrand.trim();
    }

    public Date getCompanyEstablishmentTime() {
        return companyEstablishmentTime;
    }

    public void setCompanyEstablishmentTime(Date companyEstablishmentTime) {
        this.companyEstablishmentTime = companyEstablishmentTime;
    }

    public String getWorkplaceOwnership() {
        return workplaceOwnership;
    }

    public void setWorkplaceOwnership(String workplaceOwnership) {
        this.workplaceOwnership = workplaceOwnership == null ? null : workplaceOwnership.trim();
    }

    public String getPlantUseRate() {
        return plantUseRate;
    }

    public void setPlantUseRate(String plantUseRate) {
        this.plantUseRate = plantUseRate == null ? null : plantUseRate.trim();
    }

    public String getProductSupplyCycle() {
        return productSupplyCycle;
    }

    public void setProductSupplyCycle(String productSupplyCycle) {
        this.productSupplyCycle = productSupplyCycle == null ? null : productSupplyCycle.trim();
    }

    public String getFeedbackTime() {
        return feedbackTime;
    }

    public void setFeedbackTime(String feedbackTime) {
        this.feedbackTime = feedbackTime == null ? null : feedbackTime.trim();
    }

    public String getPpmPerformance() {
        return ppmPerformance;
    }

    public void setPpmPerformance(String ppmPerformance) {
        this.ppmPerformance = ppmPerformance == null ? null : ppmPerformance.trim();
    }

    public Date getAgentTime() {
        return agentTime;
    }

    public void setAgentTime(Date agentTime) {
        this.agentTime = agentTime;
    }

    public String getActingProducts() {
        return actingProducts;
    }

    public void setActingProducts(String actingProducts) {
        this.actingProducts = actingProducts == null ? null : actingProducts.trim();
    }

    public String getDeliveryMode() {
        return deliveryMode;
    }

    public void setDeliveryMode(String deliveryMode) {
        this.deliveryMode = deliveryMode == null ? null : deliveryMode.trim();
    }

    public Integer getIsFieldService() {
        return isFieldService;
    }

    public void setIsFieldService(Integer isFieldService) {
        this.isFieldService = isFieldService;
    }

    public String getBusinessLicenseNumber() {
        return businessLicenseNumber;
    }

    public void setBusinessLicenseNumber(String businessLicenseNumber) {
        this.businessLicenseNumber = businessLicenseNumber == null ? null : businessLicenseNumber.trim();
    }

    public String getCapitalType() {
        return capitalType;
    }

    public void setCapitalType(String capitalType) {
        this.capitalType = capitalType == null ? null : capitalType.trim();
    }

    public String getCompanyEnglishAbbreviation() {
        return companyEnglishAbbreviation;
    }

    public void setCompanyEnglishAbbreviation(String companyEnglishAbbreviation) {
        this.companyEnglishAbbreviation = companyEnglishAbbreviation == null ? null : companyEnglishAbbreviation.trim();
    }

    public Integer getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(Integer finishFlag) {
        this.finishFlag = finishFlag;
    }

    public String getFirstCompanyTypeExplain() {
        return firstCompanyTypeExplain;
    }

    public void setFirstCompanyTypeExplain(String firstCompanyTypeExplain) {
        this.firstCompanyTypeExplain = firstCompanyTypeExplain == null ? null : firstCompanyTypeExplain.trim();
    }

    public String getSecondCompanyTypeExplain() {
        return secondCompanyTypeExplain;
    }

    public void setSecondCompanyTypeExplain(String secondCompanyTypeExplain) {
        this.secondCompanyTypeExplain = secondCompanyTypeExplain == null ? null : secondCompanyTypeExplain.trim();
    }

    public String getCompetitionProducts() {
        return competitionProducts;
    }

    public void setCompetitionProducts(String competitionProducts) {
        this.competitionProducts = competitionProducts == null ? null : competitionProducts.trim();
    }

    public Integer getApproveStatus() {
        return approveStatus;
    }

    public void setApproveStatus(Integer approveStatus) {
        this.approveStatus = approveStatus;
    }

    public String getApproveUserName() {
        return approveUserName;
    }

    public void setApproveUserName(String approveUserName) {
        this.approveUserName = approveUserName == null ? null : approveUserName.trim();
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getBusinessScope() {
        return businessScope;
    }

    public void setBusinessScope(String businessScope) {
        this.businessScope = businessScope == null ? null : businessScope.trim();
    }

    public String getProductionAddress() {
        return productionAddress;
    }

    public void setProductionAddress(String productionAddress) {
        this.productionAddress = productionAddress == null ? null : productionAddress.trim();
    }

    public BigDecimal getLandArea() {
        return landArea;
    }

    public void setLandArea(BigDecimal landArea) {
        this.landArea = landArea;
    }

    public BigDecimal getTotalBuildingArea() {
        return totalBuildingArea;
    }

    public void setTotalBuildingArea(BigDecimal totalBuildingArea) {
        this.totalBuildingArea = totalBuildingArea;
    }

    public BigDecimal getPlantArea() {
        return plantArea;
    }

    public void setPlantArea(BigDecimal plantArea) {
        this.plantArea = plantArea;
    }

    public Integer getManagerNumber() {
        return managerNumber;
    }

    public void setManagerNumber(Integer managerNumber) {
        this.managerNumber = managerNumber;
    }

    public Integer getSalesmanNumber() {
        return salesmanNumber;
    }

    public void setSalesmanNumber(Integer salesmanNumber) {
        this.salesmanNumber = salesmanNumber;
    }

    public Integer getTechnicianNumber() {
        return technicianNumber;
    }

    public void setTechnicianNumber(Integer technicianNumber) {
        this.technicianNumber = technicianNumber;
    }

    public Integer getQualityInspectorNumber() {
        return qualityInspectorNumber;
    }

    public void setQualityInspectorNumber(Integer qualityInspectorNumber) {
        this.qualityInspectorNumber = qualityInspectorNumber;
    }

    public Integer getWorkerNumber() {
        return workerNumber;
    }

    public void setWorkerNumber(Integer workerNumber) {
        this.workerNumber = workerNumber;
    }

    public Integer getTotalNumber() {
        return totalNumber;
    }

    public void setTotalNumber(Integer totalNumber) {
        this.totalNumber = totalNumber;
    }

    public BigDecimal getProductCapacity() {
        return productCapacity;
    }

    public void setProductCapacity(BigDecimal productCapacity) {
        this.productCapacity = productCapacity;
    }

    public String getClassificationThree() {
        return classificationThree;
    }

    public void setClassificationThree(String classificationThree) {
        this.classificationThree = classificationThree == null ? null : classificationThree.trim();
    }

    public String getGrade() {
        return grade;
    }

    public void setGrade(String grade) {
        this.grade = grade == null ? null : grade.trim();
    }

    public BigDecimal getMonthlyCapacity() {
        return monthlyCapacity;
    }

    public void setMonthlyCapacity(BigDecimal monthlyCapacity) {
        this.monthlyCapacity = monthlyCapacity;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getCompanyRetrieve() {
        return companyRetrieve;
    }

    public void setCompanyRetrieve(String companyRetrieve) {
        this.companyRetrieve = companyRetrieve == null ? null : companyRetrieve.trim();
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode == null ? null : taxCode.trim();
    }

    public String getOutsourcingProcess() {
        return outsourcingProcess;
    }

    public void setOutsourcingProcess(String outsourcingProcess) {
        this.outsourcingProcess = outsourcingProcess == null ? null : outsourcingProcess.trim();
    }

    public String getCoupletNumber() {
        return coupletNumber;
    }

    public void setCoupletNumber(String coupletNumber) {
        this.coupletNumber = coupletNumber == null ? null : coupletNumber.trim();
    }

    public String getAwardSituation() {
        return awardSituation;
    }

    public void setAwardSituation(String awardSituation) {
        this.awardSituation = awardSituation == null ? null : awardSituation.trim();
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType == null ? null : productType.trim();
    }

    public String getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId == null ? null : categoryId.trim();
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode == null ? null : categoryCode.trim();
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName == null ? null : categoryName.trim();
    }

    public String getPurchaseCycle() {
        return purchaseCycle;
    }

    public void setPurchaseCycle(String purchaseCycle) {
        this.purchaseCycle = purchaseCycle == null ? null : purchaseCycle.trim();
    }

    public String getCarBusinessProportion() {
        return carBusinessProportion;
    }

    public void setCarBusinessProportion(String carBusinessProportion) {
        this.carBusinessProportion = carBusinessProportion == null ? null : carBusinessProportion.trim();
    }

    public String getTransportType() {
        return transportType;
    }

    public void setTransportType(String transportType) {
        this.transportType = transportType == null ? null : transportType.trim();
    }

    public String getTransportProProportion() {
        return transportProProportion;
    }

    public void setTransportProProportion(String transportProProportion) {
        this.transportProProportion = transportProProportion == null ? null : transportProProportion.trim();
    }

    public String getPackingProProportion() {
        return packingProProportion;
    }

    public void setPackingProProportion(String packingProProportion) {
        this.packingProProportion = packingProProportion == null ? null : packingProProportion.trim();
    }

    public String getPaymentPeriod() {
        return paymentPeriod;
    }

    public void setPaymentPeriod(String paymentPeriod) {
        this.paymentPeriod = paymentPeriod == null ? null : paymentPeriod.trim();
    }

    public String getDeliveryModeDesc() {
        return deliveryModeDesc;
    }

    public void setDeliveryModeDesc(String deliveryModeDesc) {
        this.deliveryModeDesc = deliveryModeDesc == null ? null : deliveryModeDesc.trim();
    }

    public String getTransportTypeDesc() {
        return transportTypeDesc;
    }

    public void setTransportTypeDesc(String transportTypeDesc) {
        this.transportTypeDesc = transportTypeDesc == null ? null : transportTypeDesc.trim();
    }

    public String getOrderCurrenDesc() {
        return orderCurrenDesc;
    }

    public void setOrderCurrenDesc(String orderCurrenDesc) {
        this.orderCurrenDesc = orderCurrenDesc == null ? null : orderCurrenDesc.trim();
    }

    public String getPaymentPeriodDesc() {
        return paymentPeriodDesc;
    }

    public void setPaymentPeriodDesc(String paymentPeriodDesc) {
        this.paymentPeriodDesc = paymentPeriodDesc == null ? null : paymentPeriodDesc.trim();
    }

    public String getServiceCategory() {
        return serviceCategory;
    }

    public void setServiceCategory(String serviceCategory) {
        this.serviceCategory = serviceCategory == null ? null : serviceCategory.trim();
    }

    public String getProductImportanceId() {
        return productImportanceId;
    }

    public void setProductImportanceId(String productImportanceId) {
        this.productImportanceId = productImportanceId == null ? null : productImportanceId.trim();
    }

    public String getProductImportanceName() {
        return productImportanceName;
    }

    public void setProductImportanceName(String productImportanceName) {
        this.productImportanceName = productImportanceName == null ? null : productImportanceName.trim();
    }

    public String getSymbiosisId() {
        return symbiosisId;
    }

    public void setSymbiosisId(String symbiosisId) {
        this.symbiosisId = symbiosisId == null ? null : symbiosisId.trim();
    }

    public String getSymbiosis() {
        return symbiosis;
    }

    public void setSymbiosis(String symbiosis) {
        this.symbiosis = symbiosis == null ? null : symbiosis.trim();
    }

    public String getCriticalityId() {
        return criticalityId;
    }

    public void setCriticalityId(String criticalityId) {
        this.criticalityId = criticalityId == null ? null : criticalityId.trim();
    }

    public String getCriticalityName() {
        return criticalityName;
    }

    public void setCriticalityName(String criticalityName) {
        this.criticalityName = criticalityName == null ? null : criticalityName.trim();
    }
    
    public Integer getIsOnline() {
        return isOnline;
    }

    public void setIsOnline(Integer isOnline) {
        this.isOnline = isOnline;
    }

    public String getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1 == null ? null : attribute1.trim();
    }

    public String getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2 == null ? null : attribute2.trim();
    }

    public String getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3 == null ? null : attribute3.trim();
    }

    public String getAttribute4() {
        return attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4 == null ? null : attribute4.trim();
    }

    public String getAttribute5() {
        return attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5 == null ? null : attribute5.trim();
    }
}