package com.els.base.company.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="企业信息扩展表")
public class CompanyExtend implements Serializable {
    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("企业信息company表ID")
    private String companyId;

    @ApiModelProperty("供应商sap编码")
    private String companySapCode;

    @ApiModelProperty("采购组织")
    private String purchaseOrganization;

    @ApiModelProperty("采购电话")
    private String purchasingTelephone;

    @ApiModelProperty("国际贸易条件2")
    private String internationalTradeCondition2;

    @ApiModelProperty("停用标识")
    private String disableSign;

    @ApiModelProperty("ABC标识")
    private String abcIdentification;

    @ApiModelProperty("排序码")
    private String sortCode;

    @ApiModelProperty("冻结标识符")
    private String frozenIdentifier;

    @ApiModelProperty("距康尼距离")
    private String distanceToKangni;

    @ApiModelProperty("银行开户许可证")
    private String bankOpenAcccoutLicence;

    @ApiModelProperty("近三年年产量或者产值")
    private String yearOutPut3;

    @ApiModelProperty("近三年财务报表")
    private String financialStatements3;

    @ApiModelProperty("质量水平")
    private String qualityLevel;

    @ApiModelProperty("账户类别（基本账户）")
    private String accountType;

    @ApiModelProperty("营业执照最新年检时间")
    private Date busiLicenseCheckTime;

    @ApiModelProperty("组织机构代码证最新年检时间")
    private Date orgCodeNewestCheckTime;

    @ApiModelProperty("组织机构代码")
    private String organizationCode;

    @ApiModelProperty("税务登记证最新年检时间")
    private Date taxRegiNewestCheckTime;

    @ApiModelProperty("税务登记证号码")
    private String taxRegistrationNo;

    @ApiModelProperty("生产许可证")
    private String productLicence;

    @ApiModelProperty("特殊岗位人员资质证书")
    private String specialPostCertifice;

    @ApiModelProperty("注册地址")
    private String registerAddress;

    @ApiModelProperty("开户日期")
    private Date openAccountDate;

    @ApiModelProperty("外包供方资料")
    private String outSupplierInfo;

    @ApiModelProperty("制造厂家或授权代理")
    private String manufacturer;

    @ApiModelProperty("公司负责人手机号码")
    private String companyResponsiblerPhone;

    @ApiModelProperty("公司负责人姓名")
    private String companyResponsiblerName;

    @ApiModelProperty("公司负责人固定电话")
    private String companyResponsiblerNo;

    @ApiModelProperty("供方地址")
    private String supplierAddress;

    @ApiModelProperty("供方名称")
    private String supplierName;

    @ApiModelProperty("企业认证资料")
    private String companyAuthInfo;

    @ApiModelProperty("企业认证情况")
    private String companyAuthSituation;

    @ApiModelProperty("企业获奖资料")
    private String companyWinInfo;

    @ApiModelProperty("产品认证情况")
    private String productAuthSituation;

    @ApiModelProperty("主要生产设备清单")
    private String majorProductEquipmentBill;

    @ApiModelProperty("主要检验器具和仪器清单")
    private String majorCheckerBill;

    @ApiModelProperty("主要客户及业绩")
    private String majorCustomer;

    @ApiModelProperty("银行码")
    private String bankCode;

    @ApiModelProperty("银行户主")
    private String bankAccountName;

    @ApiModelProperty("旧供应商编码（金思维ERP老编码）")
    private String oldCompanySapCode;

    @ApiModelProperty("贸易伙伴")
    private String tradePartner;

    @ApiModelProperty("语言")
    private String language;

    @ApiModelProperty("纳税人登记号")
    private String ratepayerNo;

    @ApiModelProperty("电话分机号")
    private String telephoneExten;

    @ApiModelProperty("搜索条件")
    private String searchCondition;

    @ApiModelProperty("传真分机号")
    private String faxExtenNo;

    @ApiModelProperty("2000采购组织")
    private String purchaseGroup2000;

    @ApiModelProperty("2000公司")
    private String company2000;

    @ApiModelProperty("供应商维护申请人(基本视图申请人工号)")
    private String baseViewProposer;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("邮编")
    private String postCode;

    @ApiModelProperty("联系人固定电话")
    private String contactsFixedTel;

    @ApiModelProperty("联系人手机号码")
    private String contactsMobile;

    @ApiModelProperty("联系人邮箱")
    private String contactsElecMail;
    
    @ApiModelProperty("银行所在国家")
    private String bankCountry;
    
    @ApiModelProperty("供应商SRM编码")
    private String companySrmCode;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getCompanySapCode() {
        return companySapCode;
    }

    public void setCompanySapCode(String companySapCode) {
        this.companySapCode = companySapCode == null ? null : companySapCode.trim();
    }

    public String getPurchaseOrganization() {
        return purchaseOrganization;
    }

    public void setPurchaseOrganization(String purchaseOrganization) {
        this.purchaseOrganization = purchaseOrganization == null ? null : purchaseOrganization.trim();
    }

    public String getPurchasingTelephone() {
        return purchasingTelephone;
    }

    public void setPurchasingTelephone(String purchasingTelephone) {
        this.purchasingTelephone = purchasingTelephone == null ? null : purchasingTelephone.trim();
    }

    public String getInternationalTradeCondition2() {
        return internationalTradeCondition2;
    }

    public void setInternationalTradeCondition2(String internationalTradeCondition2) {
        this.internationalTradeCondition2 = internationalTradeCondition2 == null ? null : internationalTradeCondition2.trim();
    }

    public String getDisableSign() {
        return disableSign;
    }

    public void setDisableSign(String disableSign) {
        this.disableSign = disableSign == null ? null : disableSign.trim();
    }

    public String getAbcIdentification() {
        return abcIdentification;
    }

    public void setAbcIdentification(String abcIdentification) {
        this.abcIdentification = abcIdentification == null ? null : abcIdentification.trim();
    }

    public String getSortCode() {
        return sortCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode == null ? null : sortCode.trim();
    }

    public String getFrozenIdentifier() {
        return frozenIdentifier;
    }

    public void setFrozenIdentifier(String frozenIdentifier) {
        this.frozenIdentifier = frozenIdentifier == null ? null : frozenIdentifier.trim();
    }

    public String getDistanceToKangni() {
        return distanceToKangni;
    }

    public void setDistanceToKangni(String distanceToKangni) {
        this.distanceToKangni = distanceToKangni == null ? null : distanceToKangni.trim();
    }

    public String getBankOpenAcccoutLicence() {
        return bankOpenAcccoutLicence;
    }

    public void setBankOpenAcccoutLicence(String bankOpenAcccoutLicence) {
        this.bankOpenAcccoutLicence = bankOpenAcccoutLicence == null ? null : bankOpenAcccoutLicence.trim();
    }

    public String getYearOutPut3() {
        return yearOutPut3;
    }

    public void setYearOutPut3(String yearOutPut3) {
        this.yearOutPut3 = yearOutPut3 == null ? null : yearOutPut3.trim();
    }

    public String getFinancialStatements3() {
        return financialStatements3;
    }

    public void setFinancialStatements3(String financialStatements3) {
        this.financialStatements3 = financialStatements3 == null ? null : financialStatements3.trim();
    }

    public String getQualityLevel() {
        return qualityLevel;
    }

    public void setQualityLevel(String qualityLevel) {
        this.qualityLevel = qualityLevel == null ? null : qualityLevel.trim();
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType == null ? null : accountType.trim();
    }

    public Date getBusiLicenseCheckTime() {
        return busiLicenseCheckTime;
    }

    public void setBusiLicenseCheckTime(Date busiLicenseCheckTime) {
        this.busiLicenseCheckTime = busiLicenseCheckTime;
    }

    public Date getOrgCodeNewestCheckTime() {
        return orgCodeNewestCheckTime;
    }

    public void setOrgCodeNewestCheckTime(Date orgCodeNewestCheckTime) {
        this.orgCodeNewestCheckTime = orgCodeNewestCheckTime;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode == null ? null : organizationCode.trim();
    }

    public Date getTaxRegiNewestCheckTime() {
        return taxRegiNewestCheckTime;
    }

    public void setTaxRegiNewestCheckTime(Date taxRegiNewestCheckTime) {
        this.taxRegiNewestCheckTime = taxRegiNewestCheckTime;
    }

    public String getTaxRegistrationNo() {
        return taxRegistrationNo;
    }

    public void setTaxRegistrationNo(String taxRegistrationNo) {
        this.taxRegistrationNo = taxRegistrationNo == null ? null : taxRegistrationNo.trim();
    }

    public String getProductLicence() {
        return productLicence;
    }

    public void setProductLicence(String productLicence) {
        this.productLicence = productLicence == null ? null : productLicence.trim();
    }

    public String getSpecialPostCertifice() {
        return specialPostCertifice;
    }

    public void setSpecialPostCertifice(String specialPostCertifice) {
        this.specialPostCertifice = specialPostCertifice == null ? null : specialPostCertifice.trim();
    }

    public String getRegisterAddress() {
        return registerAddress;
    }

    public void setRegisterAddress(String registerAddress) {
        this.registerAddress = registerAddress == null ? null : registerAddress.trim();
    }

    public Date getOpenAccountDate() {
        return openAccountDate;
    }

    public void setOpenAccountDate(Date openAccountDate) {
        this.openAccountDate = openAccountDate;
    }

    public String getOutSupplierInfo() {
        return outSupplierInfo;
    }

    public void setOutSupplierInfo(String outSupplierInfo) {
        this.outSupplierInfo = outSupplierInfo == null ? null : outSupplierInfo.trim();
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer == null ? null : manufacturer.trim();
    }

    public String getCompanyResponsiblerPhone() {
        return companyResponsiblerPhone;
    }

    public void setCompanyResponsiblerPhone(String companyResponsiblerPhone) {
        this.companyResponsiblerPhone = companyResponsiblerPhone == null ? null : companyResponsiblerPhone.trim();
    }

    public String getCompanyResponsiblerName() {
        return companyResponsiblerName;
    }

    public void setCompanyResponsiblerName(String companyResponsiblerName) {
        this.companyResponsiblerName = companyResponsiblerName == null ? null : companyResponsiblerName.trim();
    }

    public String getCompanyResponsiblerNo() {
        return companyResponsiblerNo;
    }

    public void setCompanyResponsiblerNo(String companyResponsiblerNo) {
        this.companyResponsiblerNo = companyResponsiblerNo == null ? null : companyResponsiblerNo.trim();
    }

    public String getSupplierAddress() {
        return supplierAddress;
    }

    public void setSupplierAddress(String supplierAddress) {
        this.supplierAddress = supplierAddress == null ? null : supplierAddress.trim();
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName == null ? null : supplierName.trim();
    }

    public String getCompanyAuthInfo() {
        return companyAuthInfo;
    }

    public void setCompanyAuthInfo(String companyAuthInfo) {
        this.companyAuthInfo = companyAuthInfo == null ? null : companyAuthInfo.trim();
    }

    public String getCompanyAuthSituation() {
        return companyAuthSituation;
    }

    public void setCompanyAuthSituation(String companyAuthSituation) {
        this.companyAuthSituation = companyAuthSituation == null ? null : companyAuthSituation.trim();
    }

    public String getCompanyWinInfo() {
        return companyWinInfo;
    }

    public void setCompanyWinInfo(String companyWinInfo) {
        this.companyWinInfo = companyWinInfo == null ? null : companyWinInfo.trim();
    }

    public String getProductAuthSituation() {
        return productAuthSituation;
    }

    public void setProductAuthSituation(String productAuthSituation) {
        this.productAuthSituation = productAuthSituation == null ? null : productAuthSituation.trim();
    }

    public String getMajorProductEquipmentBill() {
        return majorProductEquipmentBill;
    }

    public void setMajorProductEquipmentBill(String majorProductEquipmentBill) {
        this.majorProductEquipmentBill = majorProductEquipmentBill == null ? null : majorProductEquipmentBill.trim();
    }

    public String getMajorCheckerBill() {
        return majorCheckerBill;
    }

    public void setMajorCheckerBill(String majorCheckerBill) {
        this.majorCheckerBill = majorCheckerBill == null ? null : majorCheckerBill.trim();
    }

    public String getMajorCustomer() {
        return majorCustomer;
    }

    public void setMajorCustomer(String majorCustomer) {
        this.majorCustomer = majorCustomer == null ? null : majorCustomer.trim();
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode == null ? null : bankCode.trim();
    }

    public String getBankAccountName() {
        return bankAccountName;
    }

    public void setBankAccountName(String bankAccountName) {
        this.bankAccountName = bankAccountName == null ? null : bankAccountName.trim();
    }

    public String getOldCompanySapCode() {
        return oldCompanySapCode;
    }

    public void setOldCompanySapCode(String oldCompanySapCode) {
        this.oldCompanySapCode = oldCompanySapCode == null ? null : oldCompanySapCode.trim();
    }

    public String getTradePartner() {
        return tradePartner;
    }

    public void setTradePartner(String tradePartner) {
        this.tradePartner = tradePartner == null ? null : tradePartner.trim();
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language == null ? null : language.trim();
    }

    public String getRatepayerNo() {
        return ratepayerNo;
    }

    public void setRatepayerNo(String ratepayerNo) {
        this.ratepayerNo = ratepayerNo == null ? null : ratepayerNo.trim();
    }

    public String getTelephoneExten() {
        return telephoneExten;
    }

    public void setTelephoneExten(String telephoneExten) {
        this.telephoneExten = telephoneExten == null ? null : telephoneExten.trim();
    }

    public String getSearchCondition() {
        return searchCondition;
    }

    public void setSearchCondition(String searchCondition) {
        this.searchCondition = searchCondition == null ? null : searchCondition.trim();
    }

    public String getFaxExtenNo() {
        return faxExtenNo;
    }

    public void setFaxExtenNo(String faxExtenNo) {
        this.faxExtenNo = faxExtenNo == null ? null : faxExtenNo.trim();
    }

    public String getPurchaseGroup2000() {
        return purchaseGroup2000;
    }

    public void setPurchaseGroup2000(String purchaseGroup2000) {
        this.purchaseGroup2000 = purchaseGroup2000 == null ? null : purchaseGroup2000.trim();
    }

    public String getCompany2000() {
        return company2000;
    }

    public void setCompany2000(String company2000) {
        this.company2000 = company2000 == null ? null : company2000.trim();
    }

    public String getBaseViewProposer() {
        return baseViewProposer;
    }

    public void setBaseViewProposer(String baseViewProposer) {
        this.baseViewProposer = baseViewProposer == null ? null : baseViewProposer.trim();
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode == null ? null : postCode.trim();
    }

    public String getContactsFixedTel() {
        return contactsFixedTel;
    }

    public void setContactsFixedTel(String contactsFixedTel) {
        this.contactsFixedTel = contactsFixedTel == null ? null : contactsFixedTel.trim();
    }

    public String getContactsMobile() {
        return contactsMobile;
    }

    public void setContactsMobile(String contactsMobile) {
        this.contactsMobile = contactsMobile == null ? null : contactsMobile.trim();
    }

    public String getContactsElecMail() {
        return contactsElecMail;
    }

    public void setContactsElecMail(String contactsElecMail) {
        this.contactsElecMail = contactsElecMail == null ? null : contactsElecMail.trim();
    }
    
    public String getBankCountry() {
        return bankCountry;
    }

    public void setBankCountry(String bankCountry) {
        this.bankCountry = bankCountry == null ? null : bankCountry.trim();
    }
    
    public String getCompanySrmCode() {
        return companySrmCode;
    }

    public void setCompanySrmCode(String companySrmCode) {
        this.companySrmCode = companySrmCode == null ? null : companySrmCode.trim();
    }
}