package com.els.base.company.event.listener;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.event.CompanyCreatedSuccessEvent;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;

/**
 * 监听创建供应商的事件
 */
@Component
public class CompanyCreatedSuccessListener implements ApplicationListener<CompanyCreatedSuccessEvent>{

	@Resource
    private UserService userService;
	
	@Resource
    private CompanyUserRefService companyUserRefService;
	
	@Resource
    private ProjectService projectService;
	
	@Transactional
	@Override
	public void onApplicationEvent(CompanyCreatedSuccessEvent event) {
		//接收传过来的公司参数
		Company company = (Company) event.getSource();
		
		Project project=projectService.queryObjById(company.getProjectId());
		if(project==null || StringUtils.isBlank(project.getProjectCode())){
			throw new CommonException("ProjectCode不能为空","base_canot_be_null","ProjectCode");
		}
		//创建一个用户
		User t=new User();
		t.setEmail(company.getEmail());
		t.setMobilePhone(company.getMobilephone());
		t.setLoginName(company.getCompanyCode());
		
		//创建用户账号
		t.setPassword(User.DEFAULT_PASSWORD);
		t.setIsEnable(Constant.YES_INT);
		t.setProjectCode(project.getProjectCode());
		
		try {
			userService.addObj(t);
		} catch (Exception e) {
			throw new CommonException("请求失败","base_fail");
		}
		
		//创建公司与用户之间的依赖关系
		CompanyUserRef userRef=new CompanyUserRef();
		userRef.setCompanyId(company.getId());
		userRef.setProjectId(company.getProjectId());
		userRef.setUserId(t.getId());
		companyUserRefService.addObj(userRef);
		
	}
}
