package com.els.base.company.service;

import java.util.List;

import com.els.base.company.entity.CompanyAddress;
import com.els.base.company.entity.CompanyAddressExample;
import com.els.base.core.service.BaseService;

public interface CompanyAddressService extends BaseService<CompanyAddress, CompanyAddressExample, String> {
	
	/**
	 * 根据公司ID查询全部公司地址
	 * @param companyId
	 * @return
	 */
	List<CompanyAddress> queryByCompanyId(String companyId);
	
	
    void deleteByExample(CompanyAddressExample example);
    
    void insertBatch(List<CompanyAddress> list);

    /**
     * 禁用，启用地址
     * @param id
     * @param isEnable
     * @return
     */
	int isEnable(String id, Integer isEnable);
	
	
	/**
	 * 根据公司Id,公司sap编码，语言编码返回地址
	 * @param companyId 公司ID
	 * @param addressCode 地址语言编码,公司sap编码
	 * @param languageCode 语言编码
	 * @return
	 */
	List<CompanyAddress>  queryByCompanyIdAndAddressCodeAndLanguageCode(String companyId,String addressCode,String languageCode);
	
	/**
	 * 设置默认地址
	 * @param companyId
	 * @param addressCode
	 * @param languageCode
	 * @param isDefaultAddress
	 * @return
	 */
	void updateDefaultAddress(String companyId,String addressCode,String languageCode,Integer isDefaultAddress);
	
	
}