package com.els.base.company.service;

import java.util.List;
import java.util.Set;

import com.els.base.company.entity.CompanySapRelation;
import com.els.base.company.entity.CompanySapRelationExample;
import com.els.base.core.service.BaseService;

public interface CompanySapRelationService extends BaseService<CompanySapRelation, CompanySapRelationExample, String> {

	/**
	 * 检查sapSupplierCode是否已经存在系统
	 * 
	 * @param sapSupplierCode
	 * @param id
	 * @return true表示已经存在，false表示不存在
	 */
	boolean checkSapSupplierCodeIfExist(String sapSupplierCode, String id);
	
	/**
	 * 根据sapSupplierCode查找客户编码
	 * 
	 * @param sapSupplierCode
	 * @return
	 */
	String findCompanyCodeBySapSupplierCode(String sapSupplierCode);
	
	/**
	 * 从EXCEL导入数据
	 * 
	 * @param list
	 */
	void importFromExcel(List<CompanySapRelation> list);
	
	/**
	 * 支持删除多条记录
	 * @param ids
	 */
	void deleteByIds(Set<String> ids);
	
	/**
	 * 根据companyCode查找SAP编码
	 * 
	 * @param sapSupplierCode
	 * @return
	 */
	List<String> findSapCodeByCompanyCode(String companyCode);

	/**
	 * 根据Srm code 和Sap code 查找关系信息
	 * @param srmCode
	 * @param sapCode
	 * @return
	 */
	CompanySapRelation findBySrmCodeAndSapCode(String srmCode,String sapCode);

}