package com.els.base.company.service;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;
import java.util.Map;

public interface CompanyService extends BaseService<Company, CompanyExample, String> {

    int updateByPrimaryKeySelective(Company record);

	int updateByExampleSelective( Company record, CompanyExample example);

	/**
	 * MDM系统推送供应商数据
	 * @param record
	 * @return
	 */
	public void insertSelective(Company record);


	public  void addObjByImport(Company record);

	/**
	 * 查询集团公司下面，所有子公司
	 * @param parentId
	 * @return
	 */
	public List<Company> queryChildCompany(String parentId);
	
	/**
	 * 查询默认采购商华阳--固定
	 * @return
	 */
//	Company getDefaultCompany();
	
	/**
	 * 查询企业下的供应商，包括所有供应商角色:陌生/潜在/合格、供应商分类等
	 * @param purCompanyId 采购商id
	 * @param companyExample 对于企业的过滤条件，例如企业名称、行业等
	 * @return
	 */
	public PageView<Company> querySupplerCompanies(String purCompanyId, CompanyExample companyExample);
	
	/**
	 * 查询企业下的供应商，包括所有供应商角色:陌生/潜在/合格、供应商分类等
	 * @param purCompanyId 采购商id
	 * @param companyExample 对于企业的过滤条件，例如企业名称、行业等
	 * @return
	 */
	public PageView<Company> querySupplerCompanies(String purCompanyId, CompanyExample companyExample, String roleEnum);
	
	
	/**
	 * 供新供应商编码使用
	 * 查询企业下的供应商，包括所有供应商角色:陌生/潜在/合格、供应商分类等
	 * @param purCompanyId 采购商id
	 * @param companyExample 对于企业的过滤条件，例如企业名称、行业等
	 * @return
	 */
	public PageView<Company> querySupplerCompaniesForApply(String purCompanyId, CompanyExample companyExample, String roleEnum);
	
	/**
	 * 查询公司旗下全部的供应商
	 * @param partnerExample
	 * @param example
	 * @return
	 */
	public List<Company> queryAllSupplerCompanies(String purCompanyId, CompanyExample example);
	
	/**
	 * 分页查询企业下的采购商
	 * @param companyId
	 * @param companyExample 采购商的过滤条件
	 * @return
	 */
	public PageView<Company> queryPurchaseCompaniesByPage(String companyId, CompanyExample companyExample);
	
	/**
	 * 分页查询企业下的采购商
	 * @param companyId
	 * @param companyExample 采购商的过滤条件
	 * @return
	 */
	public List<Company> queryPurchaseCompanies(String supCompanyId, CompanyExample companyExample);

	/**
	 * 分页查询企业下的采购商，适合只有一个采购商的情况，如果有多个采购商就会报错
	 * @param companyId
	 * @param companyExample 采购商的过滤条件
	 * @return
	 */
	public Company queryPurchaseCompanies(String supCompanyId);
	
	/**
	 * 添加一个企业，并作为供应商合作伙伴
	 * @param companyPartner 合作伙伴关系
	 */
	public void addCompanyAsSupplier(CompanyPartner companyPartner);
	
	/**
	 * 改变一个供应商的合作关系
	 * @param companyId
	 * @param supplierCompany
	 * @param roleCode 
	 */
	public void changeCompanyPartnerRole(String companyId, String supplierCompany, String roleCode);
	
	/**
	 * 是否是采购商，是就返回true
	 * @param company
	 * @return
	 */
//	public boolean isPurchaserCompany(Company company);
	
	/**
	 * 是否是供应商，是就返回true
	 * @param company
	 * @return
	 */
//	public boolean isSupplierCompany(Company company);
	
	/**
	 * 启用/禁用供应商
	 * @param companyId
	 * @param idEnable
	 */
	public int isEnable(String companyId,Integer isEnable);
	
	/**
	 * 根据公司编码查询公司信息
	 * @param companyCode
	 * @return
	 */
	public Company queryCompanyByCode(String companyCode);
	
	/**
	 * 陌生供应商审核通过后变为潜在供应商
	 * @param companyPartner
	 * @param example
	 */
	public void updatePartnerRole(CompanyPartner companyPartner, CompanyPartnerExample example);


	/**
	 * 判断资料是否填写完整
	 * @param project
	 * @param company
	 * @return
	 */
	public Integer isFinish(Company company);

	/**
	 * 供应商注册
	 * @param project 
	 * @param company
	 * @param mailVerifCode
	 * @param session
	 * @return
	 */
	String register(Project project, Company company);
	
	/**
	 * 
	 * @param company
	 */
//	void modifyCompanyData(Company company);
	
	/**
	 * 根据条件查询供应商是否重复
	 * @param company
	 */
	Integer countByExample(CompanyExample example);
	
	/**
	 * 修改供应商基础资料
	 * @param project
	 * @param company
	 */
	public void modifyCompany(Project project, Company company);
	
	/**
	 * 查询采购商下的所有含sap编码的供应商
	 * @param purCompanyId
	 * @param example
	 * @param roleEnum
	 * @return
	 */
	public PageView<Company> querySupplerCompanyHaveSap(String purCompanyId, CompanyExample example, String roleEnum);
	
	/**
	 * 控制供应商是否上线SRM
	 * @param companyId
	 */
	public void disableOnlineSrm(String companyId);
	
	//新增接口
	public List<Company> querySupplerCompaniesList(String purCompanyId, CompanyExample companyExample, String roleEnum);

	PageView<Company> querySupplerCompaniesLists(String purCompanyId, CompanyExample companyExample, String roleEnum,
			Map<String, Object> queryMap);
}