package com.els.base.company.service;

import java.util.List;

import com.els.base.company.entity.Industry;
import com.els.base.company.entity.IndustryExample;
import com.els.base.core.service.BaseService;

public interface IndustryService extends BaseService<Industry, IndustryExample, String> {

	List<Industry> queryAllObj();
	
	/**
	 * 递归查询行业信息
	 * @param parentId
	 * @return
	 */
	public List<Industry> queryByParentId(String parentId);
	
	public List<Industry> findTheNextCascadedIndustryInfo(String parentId);
	
	public void deleteCascadedIndustryInfo(String parentId);
}