package com.els.base.company.service.impl;

import com.els.base.company.dao.CompanyExtendMapper;
import com.els.base.company.entity.CompanyExtend;
import com.els.base.company.entity.CompanyExtendExample;
import com.els.base.company.service.CompanyExtendService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultCompanyExtendService")
public class CompanyExtendServiceImpl implements CompanyExtendService {
    @Resource
    protected CompanyExtendMapper companyExtendMapper;

    @CacheEvict(value={"companyExtend"}, allEntries=true)
    @Override
    public void addObj(CompanyExtend t) {
    	if (StringUtils.isBlank(t.getId())) {
    		t.setCreateTime(new Date());
    		this.companyExtendMapper.insertSelective(t);
    	} else {
    		t.setUpdateTime(new Date());
    		this.companyExtendMapper.updateByPrimaryKeySelective(t);
    	}
    }

    @CacheEvict(value={"companyExtend"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyExtendMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyExtend"}, allEntries=true)
    @Override
    public void modifyObj(CompanyExtend t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyExtendMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyExtend", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyExtend queryObjById(String id) {
        return this.companyExtendMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyExtend", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyExtend> queryAllObjByExample(CompanyExtendExample example) {
        return this.companyExtendMapper.selectByExample(example);
    }

    @Cacheable(value="companyExtend", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyExtend> queryObjByPage(CompanyExtendExample example) {
        PageView<CompanyExtend> pageView = example.getPageView();
        pageView.setQueryResult(this.companyExtendMapper.selectByExampleByPage(example));
        return pageView;
    }
    
    @Cacheable(value="companyExtend", keyGenerator="redisKeyGenerator")
	@Override
	public CompanyExtend queryByCompanyId(String companyId) {
		CompanyExtendExample example = new CompanyExtendExample();
		example.createCriteria().andCompanyIdEqualTo(companyId);
		List<CompanyExtend> list = this.companyExtendMapper.selectByExample(example);
		if (CollectionUtils.isEmpty(list)) {
			return null;
		}
		return list.get(0);
	}

    @CacheEvict(value={"companyExtend"}, allEntries=true)
	@Override
	public void addAll(List<CompanyExtend> t) {
    	if(CollectionUtils.isEmpty(t)){
			return;
		}
		for (CompanyExtend companyExtend : t) {
			this.companyExtendMapper.insertSelective(companyExtend);
		}
	}

    @CacheEvict(value={"companyExtend"}, allEntries=true)
	@Override
	public void deleteByExample(CompanyExtendExample example) {
    	Assert.isNotEmpty(example.getOredCriteria(), "删除条件不能为空");
    	this.companyExtendMapper.deleteByExample(example);
	}
}