package com.els.base.company.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.company.dao.CompanyPurRefMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPurRef;
import com.els.base.company.entity.CompanyPurRefExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("defaultCompanyPurRefService")
public class CompanyPurRefServiceImpl implements CompanyPurRefService {
    @Resource
    protected CompanyPurRefMapper companyPurRefMapper;
    
    @Resource
    protected CompanyService companyService;

    @Resource
    protected  UserService userService;
    
    @Resource
    protected CompanyUserRefService companyUserRefService;
    
    @CacheEvict(value={"companyPurRef"}, allEntries=true)
    @Override
    public void addObj(CompanyPurRef t) {
        this.companyPurRefMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyPurRef"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyPurRefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyPurRef"}, allEntries=true)
    @Override
    public void modifyObj(CompanyPurRef t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyPurRefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyPurRef", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyPurRef queryObjById(String id) {
        return this.companyPurRefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyPurRef", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyPurRef> queryAllObjByExample(CompanyPurRefExample example) {
        return this.companyPurRefMapper.selectByExample(example);
    }

    @Cacheable(value="companyPurRef", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyPurRef> queryObjByPage(CompanyPurRefExample example) {
        PageView<CompanyPurRef> pageView = example.getPageView();
        pageView.setQueryResult(this.companyPurRefMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value="companyPurRef", keyGenerator="redisKeyGenerator")
	@Override
	public List<CompanyPurRef> queryAllCompanyPurRefByUserId(String userId) {
    	 if (StringUtils.isBlank(userId)) {
             throw new CommonException("id为空，操作失败","id_is_blank");
         }
    	CompanyPurRefExample example =new CompanyPurRefExample();
    	example.createCriteria().andUserIdEqualTo(userId);
		return this.queryAllObjByExample(example);
	}

//    @Cacheable(value="companyPurRef", keyGenerator="redisKeyGenerator")
	@Override
	public List<Company> queryAllCompanyByUserId(String purUserId, CompanyExample companyExample) {
		 if (StringUtils.isBlank(purUserId)) {
             throw new CommonException("id为空，操作失败","id_is_blank");
         }
    	CompanyPurRefExample example =new CompanyPurRefExample();
    	example.createCriteria().andUserIdEqualTo(purUserId);
    	List<CompanyPurRef> companyPurRefList = SpringContextHolder.getOneBean(CompanyPurRefServiceImpl.class).queryAllObjByExample(example);
    	if(CollectionUtils.isEmpty(companyPurRefList)){
    		return null;
    	}
    	List<String> companyIdList=new ArrayList<String>();
    	for (CompanyPurRef companyPurRef : companyPurRefList) {
    		if (StringUtils.isBlank(companyPurRef.getSupCompanyId())) {
				continue;
			}
    		
    		companyIdList.add(companyPurRef.getSupCompanyId());
		}
    	
    	if (CollectionUtils.isEmpty(companyIdList)) {
			return null;
		}
    	
    	if (companyExample == null) {
    		companyExample =new CompanyExample();
		}
    	
    	if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
    		companyExample.createCriteria().andIdIn(companyIdList);
		}else{
			Iterator<CompanyExample.Criteria> iterator = companyExample.getOredCriteria().iterator();
			while (iterator.hasNext()) {
				iterator.next().andIdIn(companyIdList);
			}
		}
		return this.companyService.queryAllObjByExample(companyExample);
	}

    @CacheEvict(value={"companyPurRef"}, allEntries=true)
	@Override
	public void addSupplierIntoPurchaser(String userId, Company purCompany, List<Company> supCompanyList) {
		if(StringUtils.isBlank(userId)){
			throw new CommonException("userId为空","id_is_blank");
		}
		User user=userService.queryObjById(userId);
		if(user==null){
			throw new CommonException("用户不存在","do_not_exists","用户");
		}
		if(CollectionUtils.isEmpty(supCompanyList)){
			throw new CommonException("供应商列表不能为空","base_canot_be_null","供应商列表");
		}
		
		//删除该用户下的供应商关系
		CompanyPurRefExample companyPurRefExample=new CompanyPurRefExample();
		CompanyPurRefExample.Criteria companyPurRefCriteria =companyPurRefExample.createCriteria();
		companyPurRefCriteria.andProjectIdEqualTo(purCompany.getProjectId());
		companyPurRefCriteria.andUserIdEqualTo(userId);
		this.companyPurRefMapper.deleteByExample(companyPurRefExample);
		
		//插入传入的供应商关系
		for (Company company : supCompanyList) {
			CompanyPurRef companyPurRef=new CompanyPurRef();
			companyPurRef.setUserId(userId);
			companyPurRef.setSupCompanyId(company.getId());
			companyPurRef.setPurCompanyId(purCompany.getId());
			companyPurRef.setProjectId(purCompany.getProjectId());
			companyPurRef.setId(UUIDGenerator.generateUUID());
			companyPurRef.setCreateTime(new Date());
			this.companyPurRefMapper.insertSelective(companyPurRef);
		}
	}
    
    @Cacheable(value="companyPurRef", keyGenerator="redisKeyGenerator")
    @Override
	public List<FriendGroup> queryPurchaseUser(CompanyPurRefExample companyPurRefExample) {
		List<CompanyPurRef> companyPurRefList=  companyPurRefMapper.selectByExample(companyPurRefExample);
		
		//遍历该用户下的供应商列表
		List<FriendGroup> friendGroupList=new ArrayList<FriendGroup>();
		
		if(CollectionUtils.isEmpty(companyPurRefList)){
			return friendGroupList;
		}
		
		for (CompanyPurRef companyPurRef : companyPurRefList) {
			//根据公司ID查询到该公司下的用户
			CompanyUserRefExample companyUserRefExample=new CompanyUserRefExample();
			CompanyUserRefExample.Criteria companyUserRefExampleCriteria =companyUserRefExample.createCriteria();
			companyUserRefExampleCriteria.andCompanyIdEqualTo(companyPurRef.getSupCompanyId());
			companyUserRefExampleCriteria.andProjectIdEqualTo(companyPurRef.getProjectId());
//			List<CompanyUserRef> companyUserRefList=companyUserRefMapper.selectByExample(companyUserRefExample);
			List<CompanyUserRef> companyUserRefList= this.companyUserRefService.queryAllObjByExample(companyUserRefExample);
			if(CollectionUtils.isEmpty(companyUserRefList)){
				continue;
			}
			
			//封装公司信息
			FriendGroup friendGroup=new FriendGroup();
			CompanyUserRef companyUserRef=companyUserRefList.get(0);
			friendGroup.setCompany(this.companyService.queryObjById(companyUserRef.getCompanyId()));
			List<User> userList=new ArrayList<User>();
			//封装用户信息
			for (CompanyUserRef companyUser : companyUserRefList) {
				User user=userService.queryObjById(companyUser.getUserId());
				if(user == null){
					continue;
				}
				userList.add(user);
			}
			friendGroup.setUserList(userList);
			friendGroupList.add(friendGroup);
		}
		return friendGroupList;
	}

	@Override
	public List<FriendGroup> queryPurchaseFriendGroup(String companyId) {
		CompanyPurRefExample example = new CompanyPurRefExample();
		example.createCriteria().andSupCompanyIdEqualTo(companyId);
		
		//1、根据供应商id，查出关联的采购员信息
		CompanyPurRefService service = SpringContextHolder.getBean("defaultCompanyPurRefService");
		List<CompanyPurRef> purRefs = service.queryAllObjByExample(example);
		
		if (CollectionUtils.isEmpty(purRefs)) {
			return null;
		}
		
		//2、把采购公司与采购员的关联关系放到map
		Map<String, List<String>> companyAndUserMap = new HashMap<>();
		for(CompanyPurRef ref: purRefs){
			List<String> userIdList = companyAndUserMap.get(ref.getPurCompanyId());
			if (userIdList == null) {
				userIdList = new ArrayList<>();
			}
			userIdList.add(ref.getUserId());
			companyAndUserMap.put(ref.getPurCompanyId(), userIdList);
		}
		if (MapUtils.isEmpty(companyAndUserMap)) {
			return null;
		}
		
		//3、把整理好的关联关系，转化为 friendgroup
		List<FriendGroup> friendGroupVOs = new ArrayList<>();
		
		Iterator<String> companyIdIterator = companyAndUserMap.keySet().iterator();
		while (companyIdIterator.hasNext()) {
			String purCompanyId = companyIdIterator.next();
			Company purCompany = this.companyService.queryObjById(purCompanyId);
			
			UserExample userExample = new UserExample();
			userExample.createCriteria().andIdIn(companyAndUserMap.get(purCompanyId)).andIsEnableEqualTo(Constant.YES_INT);
		
			FriendGroup friendGroup = new FriendGroup();
			friendGroup.setCompany(purCompany);
			friendGroup.setUserList(this.userService.queryAllObjByExample(userExample));
			friendGroupVOs.add(friendGroup);
		}
		
		return friendGroupVOs;
	}

	@Override
	public FriendGroup queryPurchaseFriendGroup(String supCompanyId, String purCompanyId) {
		CompanyPurRefExample example = new CompanyPurRefExample();
		example.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andPurCompanyIdEqualTo(purCompanyId);
		
		CompanyPurRefService service = SpringContextHolder.getBean("defaultCompanyPurRefService");
		List<CompanyPurRef> purRefs = service.queryAllObjByExample(example);
		
		if (CollectionUtils.isEmpty(purRefs)) {
			return null;
		}

		List<String> userIdList = new ArrayList<>();
		for(CompanyPurRef ref: purRefs){
			userIdList.add(ref.getUserId());
		}
		
		UserExample userExample = new UserExample();
		userExample.createCriteria().andIdIn(userIdList).andIsEnableEqualTo(Constant.YES_INT);
		
		FriendGroup friendGroup = new FriendGroup();
		friendGroup.setCompany(this.companyService.queryObjById(purCompanyId));
		friendGroup.setUserList(this.userService.queryAllObjByExample(userExample));
		return friendGroup;
	}

	@Override
	public List<FriendGroup> querySupplyFriendGroup(String purUserId) {
		CompanyPurRefExample purRefExample = new CompanyPurRefExample();
		purRefExample.createCriteria().andUserIdEqualTo(purUserId);
		
		CompanyPurRefService service = SpringContextHolder.getBean("defaultCompanyPurRefService");
		List<CompanyPurRef> purRefs = service.queryAllObjByExample(purRefExample);
		
		if (CollectionUtils.isEmpty(purRefs)) {
			return null;
		}
		
		List<FriendGroup> friendGroups = new ArrayList<>();
		for(CompanyPurRef ref: purRefs){
			
			String supCompanyId = ref.getSupCompanyId();
			Company supCompany = this.companyService.queryObjById(supCompanyId);
			if (supCompany == null) {
				continue;
			}
			
			FriendGroup friendGroup = new FriendGroup();
			friendGroup.setCompany(supCompany);

			List<String> userIdList = this.companyUserRefService.queryUserOfCompany(supCompanyId);
			
			if (CollectionUtils.isNotEmpty(userIdList)) {
				UserExample userExample = new UserExample();
				userExample.createCriteria().andIdIn(userIdList).andIsEnableEqualTo(Constant.YES_INT);
				friendGroup.setUserList(this.userService.queryAllObjByExample(userExample));
			}
			
			friendGroups.add(friendGroup);
		}
		
		return friendGroups;
	}

	@Override
	public PageView<Company> queryAllCompanyForPageView(String purUserId, CompanyExample companyExample) {
		if (StringUtils.isBlank(purUserId)) {
            return null;
        }
	   	CompanyPurRefExample example =new CompanyPurRefExample();
	   	example.createCriteria().andUserIdEqualTo(purUserId);
	   	List<CompanyPurRef> companyPurRefList = SpringContextHolder.getOneBean(CompanyPurRefServiceImpl.class).queryAllObjByExample(example);
	   	if(CollectionUtils.isEmpty(companyPurRefList)){
	   		return null;
	   	}
	   	List<String> companyIdList=new ArrayList<String>();
	   	for (CompanyPurRef companyPurRef : companyPurRefList) {
	   		if (StringUtils.isBlank(companyPurRef.getSupCompanyId())) {
					continue;
			}
	   		companyIdList.add(companyPurRef.getSupCompanyId());
		}
	   	
	   	if (CollectionUtils.isEmpty(companyIdList)) {
			return null;
		}
	   	
	   	if (companyExample == null) {
	   		companyExample =new CompanyExample();
		}
	   	
	   	if (CollectionUtils.isEmpty(companyExample.getOredCriteria())) {
	   		companyExample.createCriteria().andIdIn(companyIdList);
		}else{
			Iterator<CompanyExample.Criteria> iterator = companyExample.getOredCriteria().iterator();
			while (iterator.hasNext()) {
				iterator.next().andIdIn(companyIdList);
			}
		}
	   	return this.companyService.queryObjByPage(companyExample);
	}

	@CacheEvict(value={"companyPurRef"}, allEntries=true)
	@Override
	public void addAll(List<CompanyPurRef> arg0) {
		if(CollectionUtils.isEmpty(arg0)){
			return;
		}
		this.companyPurRefMapper.insertBatch(arg0);
	}

	@CacheEvict(value={"companyPurRef"}, allEntries=true)
	@Override
	public void deleteByExample(CompanyPurRefExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.companyPurRefMapper.deleteByExample(arg0);
	}

//    @Cacheable(value="companyPurRef", keyGenerator="redisKeyGenerator")
//	@Override
//	public List<CompanyContactUserInfoVO> findCompanyContactUserInfoByCompanyId(String companyId) {
//		if(StringUtils.isBlank(companyId)){
//			throw new CommonException("companyId为空","id_is_blank");
//		}
//		CompanyPurRefExample companyPurRefExample=new CompanyPurRefExample();
//		CompanyPurRefExample.Criteria companyPurRefCriteria =companyPurRefExample.createCriteria();
//		companyPurRefCriteria.andCompanyIdEqualTo(companyId);
//		List<CompanyPurRef> companyPurRefList=this.queryAllObjByExample(companyPurRefExample);
//		
//		List<CompanyContactUserInfoVO> companyContactUserInfoList=new ArrayList<CompanyContactUserInfoVO>();
//		//如果没有则返回为空
//		if(CollectionUtils.isEmpty(companyPurRefList)){
//			return companyContactUserInfoList;
//		}
//		//如果存在，那么去找该负责人的公司基本信息以及该用户基本信息
//		for (CompanyPurRef companyPurRef : companyPurRefList) {
//			//封装返回的信息
//			CompanyContactUserInfoVO companyContactUserInfoVO=new CompanyContactUserInfoVO();
//			
//			//拿到该用户
//			User user = userService.queryObjById(companyPurRef.getUserId());
//			companyContactUserInfoVO.setUserId(companyPurRef.getUserId());
//			companyContactUserInfoVO.setUserName(user.getLoginName());
//			companyContactUserInfoVO.setUserCellPhone(user.getMobilePhone());
//			
//			//拿到该用户所在公司的信息
//			String purcompanyId=companyUserRefService.queryCompanyIdOfUser(companyPurRef.getUserId());
//			Company company = companyService.queryObjById(purcompanyId);
//			
//			companyContactUserInfoVO.setUserCompanyFullName(company.getCompanyFullName());
//			companyContactUserInfoVO.setUserCompanyAddress(company.getAddress());
//			
//			companyContactUserInfoList.add(companyContactUserInfoVO);
//		}
//		return companyContactUserInfoList;
//	}

}