package com.els.base.company.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.company.dao.CompanyUserRefMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.dao.user.UserMapper;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

@Service("defaultCompanyUserRefService")
public class CompanyUserRefServiceImpl implements CompanyUserRefService {
	@Resource
    protected CompanyUserRefMapper companyUserRefMapper;

    @Resource
    protected CompanyService companyService;

    @Resource
    protected UserService userService;

    @Resource
    protected RoleService roleService;

    @Resource
    protected UserRoleService userRoleService;

    @Autowired
    private UserMapper userMapper;

    @CacheEvict(value = { "companyUserRef" }, allEntries = true)
    @Override
    public void addObj(CompanyUserRef t) {
        this.companyUserRefMapper.insertSelective(t);
    }

    @CacheEvict(value = { "companyUserRef" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.companyUserRefMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "companyUserRef" }, allEntries = true)
    @Override
    public void modifyObj(CompanyUserRef t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyUserRefMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "companyUserRef", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyUserRef queryObjById(String id) {
        return this.companyUserRefMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "companyUserRef", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyUserRef> queryAllObjByExample(CompanyUserRefExample example) {
        return this.companyUserRefMapper.selectByExample(example);
    }

    @Cacheable(value = "companyUserRef", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyUserRef> queryObjByPage(CompanyUserRefExample example) {
        PageView<CompanyUserRef> pageView = example.getPageView();
        pageView.setQueryResult(this.companyUserRefMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = { "companyUserRef" }, allEntries = true)
    @Override
    public void addUserIntoCompany(String userId, String companyId) {
        Company company = this.companyService.queryObjById(companyId);
        if (company == null) {
            throw new CommonException("companyId没有对应的对象", "do_not_exists", "该公司");
        }
        CompanyUserRef ref = new CompanyUserRef();
        ref.setUserId(userId);
        ref.setProjectId(company.getProjectId());
        ref.setCompanyId(companyId);
        ref.setCreateTime(new Date());
        this.companyUserRefMapper.insertSelective(ref);
    }

    @Cacheable(value = "companyUserRef", keyGenerator="redisKeyGenerator")
    @Override
    public String queryCompanyIdOfUser(String userId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andUserIdEqualTo(userId);

        List<CompanyUserRef> list = this.companyUserRefMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }

        return list.get(0).getCompanyId();
    }

    @Cacheable(value = "companyUserRef", keyGenerator="redisKeyGenerator")
    @Override
    public List<String> queryUserOfCompany(String companyId) {
        List<String> list = new ArrayList<String>();
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andCompanyIdEqualTo(companyId);

        List<CompanyUserRef> listCompanyUserRef = this.companyUserRefMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(listCompanyUserRef)) {
            return null;
        }

        for (CompanyUserRef companyUserRef : listCompanyUserRef) {
            String userId = companyUserRef.getUserId();
            if (StringUtils.isNotBlank(userId)) {
            	list.add(userId);
			}
        }

        return list;
    }

    @CacheEvict(value = { "companyUserRef" }, allEntries = true)
    @Override
    @Transactional
    public void addSupplierIntoUser(Company company, User user) {
    	
        UserExample userEx1 = new UserExample();
        userEx1.createCriteria().andLoginNameEqualTo(user.getLoginName());

        if (userMapper.countByExample(userEx1) > 0) {
            throw new CommonException("相同用户已存在", "base_the_same_account");
        }

        UserExample userEx2 = new UserExample();
        userEx2.createCriteria().andMobilePhoneEqualTo(user.getMobilePhone());
        if (this.userMapper.countByExample(userEx2) > 0) {
            throw new CommonException("手机号已存在", "base_the_same_mobile");

        }

        UserExample userEx3 = new UserExample();
        userEx3.createCriteria().andEmailEqualTo(user.getEmail());
        if (this.userMapper.countByExample(userEx3) > 0) {
            throw new CommonException("邮箱已存在", "base_the_same_email");

        }

        if (user.getLoginName().length() > 255 || user.getQq().length() > 255
                || user.getNickName().length() > 255 || user.getWechat().length() > 255
                || user.getFax().length() > 255) {
            throw new CommonException("输入的参数长度超标", "database_length_error");
        }

        // user.setPassword(CompanyUtils.password);
        user.setIsEnable(Constant.YES_INT);

        try {
            userService.addObj(user);
        } catch (Exception e) {
            throw new CommonException("请求失败", "base_fail");
        }

        // 创建供应商和用户之间的关系
        CompanyUserRef companyUserRef = new CompanyUserRef();
        companyUserRef.setProjectId(company.getProjectId());
        companyUserRef.setCompanyId(company.getId());
        companyUserRef.setUserId(user.getId());
        this.companyUserRefMapper.insertSelective(companyUserRef);

        // 分配角色
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria roleExampleCriteria = roleExample.createCriteria();
        roleExampleCriteria.andRoleCodeEqualTo("supplier");
        List<Role> list = roleService.queryAllObjByExample(roleExample);
        if (CollectionUtils.isNotEmpty(list)) {
            UserRole t = new UserRole();
            t.setUserId(user.getId());
            t.setRoleId(list.get(0).getId());
            t.setCreateTime(new Date());
            userRoleService.addObj(t);
        }
    }
    @Cacheable(value="companyUserRef", keyGenerator="redisKeyGenerator")
	@Override
	public List<FriendGroup> findSupplierUser(CompanyUserRefExample companyUserRefExample) {
		//遍历该用户下的供应商列表
		List<CompanyUserRef> companyUserRefList=companyUserRefMapper.selectByExample(companyUserRefExample);
		List<FriendGroup> friendGroupList=new ArrayList<FriendGroup>();
		if(CollectionUtils.isNotEmpty(companyUserRefList)){
			//封装公司信息
			FriendGroup friendGroup=new FriendGroup();
			CompanyUserRef companyUserRef=companyUserRefList.get(0);
			if(companyUserRef!=null){
				friendGroup.setCompany(this.companyService.queryObjById(companyUserRef.getCompanyId()));
				List<User> userList=new ArrayList<User>();
				//封装用户信息
				for (CompanyUserRef companyUser : companyUserRefList) {
					User user=userService.queryObjById(companyUser.getUserId());
					if(user == null){
						continue;
					}
					userList.add(user);
				}
				if(CollectionUtils.isNotEmpty(userList)){
					friendGroup.setUserList(userList);
				}
				friendGroupList.add(friendGroup);
			}
		    return friendGroupList;
		}else{
			return friendGroupList;
		}
	}

	@Override
	public List<User> queryUserListOfCompany(String supCompanyId) {

		CompanyUserRefExample example = new CompanyUserRefExample();
		example.createCriteria().andCompanyIdEqualTo(supCompanyId);
		
		List<CompanyUserRef> listCompanyUserRef = this.companyUserRefMapper.selectByExample(example);
		if (CollectionUtils.isEmpty(listCompanyUserRef)) {
			return null;
		}
		List<String> userIds = new ArrayList<>();
		for(CompanyUserRef ref: listCompanyUserRef){
			userIds.add(ref.getUserId());
		}
		
		UserExample userExample = new UserExample();
		userExample.createCriteria().andIdIn(userIds);
		example.setOrderByClause("CREATE_TIME ASC");
		List<User> userList = this.userService.queryAllObjByExample(userExample);
		return userList;
		
	}

	@Override
	public User queryMainUserOfCompany(String companyId) {
		CompanyUserRefExample refExample = new CompanyUserRefExample();
		refExample.createCriteria().andCompanyIdEqualTo(companyId);
		List<CompanyUserRef> userRef = this.companyUserRefMapper.selectByExample(refExample);
		if (CollectionUtils.isEmpty(userRef)) {
			return null;
		}
		
		
		User user = this.userService.queryObjById(userRef.get(0).getUserId());
		
		if (user == null) {
			return null;
		}
		
		return user;
	}

	@CacheEvict(value = { "companyUserRef" }, allEntries = true)
	@Override
	public void addAll(List<CompanyUserRef> arg0) {

		if(CollectionUtils.isEmpty(arg0)){
			return;
		}
		this.companyUserRefMapper.insertBatch(arg0);
			
	}

	@CacheEvict(value = { "companyUserRef" }, allEntries = true)
	@Override
	public void deleteByExample(CompanyUserRefExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.companyUserRefMapper.deleteByExample(arg0);
	}
}