package com.els.base.company.service.impl;

import com.els.base.company.dao.KnManageFileMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.KnManageFile;
import com.els.base.company.entity.KnManageFileExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.service.KnManageFileService;
import com.els.base.company.vo.KnManageFileEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultKnManageFileService")
public class KnManageFileServiceImpl implements KnManageFileService {
    @Resource
    protected KnManageFileMapper knManageFileMapper;

    @Resource
    protected CompanyService companyService;

    @Resource
    protected CompanyUserRefService companyUserRefService;

    @CacheEvict(value = {"knManageFile"}, allEntries = true)
    @Override
    public void addObj(KnManageFile t) {
        t.setCreateTime(new Date());
        this.knManageFileMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value = {"knManageFile"}, allEntries = true)
    @Override
    public void addAll(List<KnManageFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.knManageFileMapper.insertBatch(list);
    }

    @CacheEvict(value = {"knManageFile"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.knManageFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"knManageFile"}, allEntries = true)
    @Override
    public void deleteByExample(KnManageFileExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.knManageFileMapper.deleteByExample(example);
    }

    @CacheEvict(value = {"knManageFile"}, allEntries = true)
    @Override
    public void modifyObj(KnManageFile t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        t.setUpdateTime(new Date());
        this.knManageFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "knManageFile", keyGenerator = "redisKeyGenerator")
    @Override
    public KnManageFile queryObjById(String id) {
        return this.knManageFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "knManageFile", keyGenerator = "redisKeyGenerator")
    @Override
    public List<KnManageFile> queryAllObjByExample(KnManageFileExample example) {
        return this.knManageFileMapper.selectByExample(example);
    }

    @Cacheable(value = "knManageFile", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<KnManageFile> queryObjByPage(KnManageFileExample example) {
        PageView<KnManageFile> pageView = example.getPageView();
        pageView.setQueryResult(this.knManageFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void outTimeReply() {
        //拿到所有证书过期的数据
        KnManageFileExample knManageFileExample = new KnManageFileExample();
        knManageFileExample.createCriteria().
                andCertificateValidityUntilLessThanOrEqualTo(new Date());
        List<KnManageFile> knManageFileList = this.knManageFileMapper.selectByExample(knManageFileExample);
        /*Map<String, List<KnManageFile>> collect = knManageFileList.stream().
                collect(Collectors.groupingBy(KnManageFile::getSupCompanySapCode));
        for (Map.Entry<String,List<KnManageFile>> entry : collect.entrySet()){

        }*/
        //发送消息给供应商和供应商管理员
        List<String> companySapCodeList = knManageFileList.stream().
                map(KnManageFile::getSupCompanySapCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(companySapCodeList)) {
            for (int i = 0; i < companySapCodeList.size(); i++) {
                CompanyExample example = new CompanyExample();
                example.createCriteria().andCompanySapCodeEqualTo(companySapCodeList.get(i));
                List<Company> companyList = this.companyService.queryAllObjByExample(example);
                User user = companyUserRefService.queryMainUserOfCompany(companyList.get(0).getId());
                List<String> userOfCompanyList = companyUserRefService.queryUserOfCompany(companyList.get(0).getId());
                userOfCompanyList.add(user.getId());
                KnManageFile knManageFile = new KnManageFile();
                Message<KnManageFile> message = Message.init(knManageFile)
                        .setCompanyCode(companySapCodeList.get(i))
                        .setSenderId("1")
                        .addReceiverIdList(userOfCompanyList)
                        .setMsgLevel(MessageLevelEnum.HIGH)
                        .setBusinessTypeCode(KnManageFileEnum.CERTIFICATE_OUT_TIME_REPLY.getDesc());
                MessageSendUtils.sendMessage(message);
            }
        }
    }

    @CacheEvict(value = {"knManageFile"}, allEntries = true)
    @Override
    public void modifyAllObjByCompanyCode(List<KnManageFile> knManageFileList) {
        List<String> stringList = knManageFileList.stream().
                map(KnManageFile::getSupCompanyCode).distinct().collect(Collectors.toList());
        KnManageFileExample knManageFileExample = new KnManageFileExample();
        knManageFileExample.createCriteria().andSupCompanyCodeIn(stringList);
        this.knManageFileMapper.deleteByExample(knManageFileExample);
        for (int i = 0; i < knManageFileList.size(); i++) {
            knManageFileList.get(i).setUpdateTime(new Date());
            this.knManageFileMapper.insertSelective(knManageFileList.get(i));
        }
    }
}