package com.els.base.company.service.impl;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.service.user.UserExtInfoQueryService;

/**
 * 给用户的拓展信息里，设置公司信息
 * @author hzy
 *
 */
@Component
public class QueryCompanyForUser implements UserExtInfoQueryService<Company> {

	@Resource
	private CompanyUserRefService companyUserRefService;
	
	@Resource
	private CompanyService companyService;
	
	@Override
	public String getExtKey() {
		return "company";
	}

	@Override
	public Company getData(String userId) {
		return this.companyService.queryObjById(this.companyUserRefService.queryCompanyIdOfUser(userId));
	}
	
}
