package com.els.base.company.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.company.dao.SupplyGoodsDictMapper;
import com.els.base.company.entity.SupplyGoodsDict;
import com.els.base.company.entity.SupplyGoodsDictExample;
import com.els.base.company.service.SupplyGoodsDictService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;

@Service("defaultSupplyGoodsDictService")
public class SupplyGoodsDictServiceImpl implements SupplyGoodsDictService {
    @Resource
    protected SupplyGoodsDictMapper supplyGoodsDictMapper;

    @CacheEvict(value={"supplyGoodsDict"}, allEntries=true)
    @Override
    public void addObj(SupplyGoodsDict t) {
        this.supplyGoodsDictMapper.insertSelective(t);
    }

    @CacheEvict(value={"supplyGoodsDict"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.supplyGoodsDictMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"supplyGoodsDict"}, allEntries=true)
    @Override
    public void modifyObj(SupplyGoodsDict t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.supplyGoodsDictMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="supplyGoodsDict", keyGenerator="redisKeyGenerator")
    @Override
    public SupplyGoodsDict queryObjById(String id) {
        return this.supplyGoodsDictMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="supplyGoodsDict", keyGenerator="redisKeyGenerator")
    @Override
    public List<SupplyGoodsDict> queryAllObjByExample(SupplyGoodsDictExample example) {
        return this.supplyGoodsDictMapper.selectByExample(example);
    }

    @Cacheable(value="supplyGoodsDict", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<SupplyGoodsDict> queryObjByPage(SupplyGoodsDictExample example) {
        PageView<SupplyGoodsDict> pageView = example.getPageView();
        pageView.setQueryResult(this.supplyGoodsDictMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value="supplyGoodsDict", keyGenerator="redisKeyGenerator")
    @Transactional
	@Override
	public void addAll(List<SupplyGoodsDict> arg0) {

		if(CollectionUtils.isEmpty(arg0)){
			return;
		}
		for (SupplyGoodsDict record : arg0) {
			this.supplyGoodsDictMapper.insertSelective(record);
		}
	}

    @Cacheable(value="supplyGoodsDict", keyGenerator="redisKeyGenerator")
	@Override
	public void deleteByExample(SupplyGoodsDictExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.supplyGoodsDictMapper.deleteByExample(arg0);
	}
}