package com.els.base.company.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import com.els.base.company.dao.SupplyGoodsRefMapper;
import com.els.base.company.entity.SupplyGoodsRef;
import com.els.base.company.entity.SupplyGoodsRefExample;
import com.els.base.company.service.SupplyGoodsRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;

@Service("defaultSupplyGoodsRefService")
public class SupplyGoodsRefServiceImpl implements SupplyGoodsRefService {
	@Resource
	protected SupplyGoodsRefMapper supplyGoodsRefMapper;

	@CacheEvict(value = { "supplyGoodsRef" }, allEntries = true)
	@Override
	public void addObj(SupplyGoodsRef t) {
		
		String supplierSapCode = t.getSupplerSapCode();
		String supplyTypeSapCode = t.getSupplySapCode();
		
		SupplyGoodsRefExample example = new SupplyGoodsRefExample();
		SupplyGoodsRefExample.Criteria criteria = example.createCriteria();
		criteria.andSupplerSapCodeEqualTo(supplierSapCode);
		criteria.andSupplySapCodeEqualTo(supplyTypeSapCode);
		
		List<SupplyGoodsRef> list = this.queryAllObjByExample(example);
		
		//添加了，就不需要再添加
		if(list != null && !list.isEmpty()) {
			return;
		}

		this.supplyGoodsRefMapper.insertSelective(t);
	}

	@CacheEvict(value = { "supplyGoodsRef" }, allEntries = true)
	@Override
	public void deleteObjById(String id) {
		this.supplyGoodsRefMapper.deleteByPrimaryKey(id);
	}

	@CacheEvict(value = { "supplyGoodsRef" }, allEntries = true)
	@Override
	public void modifyObj(SupplyGoodsRef t) {
		if (StringUtils.isBlank(t.getId())) {
			throw new NullPointerException("id 为空，无法更新");
		}
		this.supplyGoodsRefMapper.updateByPrimaryKeySelective(t);
	}

	@Cacheable(value = "supplyGoodsRef", keyGenerator = "redisKeyGenerator")
	@Override
	public SupplyGoodsRef queryObjById(String id) {
		return this.supplyGoodsRefMapper.selectByPrimaryKey(id);
	}

	@Cacheable(value = "supplyGoodsRef", keyGenerator = "redisKeyGenerator")
	@Override
	public List<SupplyGoodsRef> queryAllObjByExample(SupplyGoodsRefExample example) {
		return this.supplyGoodsRefMapper.selectByExample(example);
	}

	@Cacheable(value = "supplyGoodsRef", keyGenerator = "redisKeyGenerator")
	@Override
	public PageView<SupplyGoodsRef> queryObjByPage(SupplyGoodsRefExample example) {
		PageView<SupplyGoodsRef> pageView = example.getPageView();
		pageView.setQueryResult(this.supplyGoodsRefMapper.selectByExampleByPage(example));
		return pageView;
	}

	@Cacheable(value = "supplyGoodsRef", keyGenerator = "redisKeyGenerator")
	@Override
	public void addAll(List<SupplyGoodsRef> arg0) {

		if(CollectionUtils.isEmpty(arg0)){
			return;
		}
		for (SupplyGoodsRef record : arg0) {
			this.supplyGoodsRefMapper.insertSelective(record);
		}
	}

	@Cacheable(value = "supplyGoodsRef", keyGenerator = "redisKeyGenerator")
	@Override
	public void deleteByExample(SupplyGoodsRefExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.supplyGoodsRefMapper.deleteByExample(arg0);
	}
}