package com.els.base.company.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.*;
import com.els.base.company.service.*;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.FinishFlagUtils;
import com.els.base.company.vo.CompanyVo;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(value = "企业信息")
@Controller
@RequestMapping("company")
public class CompanyController {
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected UserService userService;
    @Resource
    protected CompanyAddressService companyAddressService;
    @Resource
    protected CompanyExtendService companyExtendService;

    @ApiOperation(httpMethod = "POST", value = "采购编辑企业税率，税码，供应商检索项信息")
    @RequestMapping("service/editForPur")
    @ResponseBody
    public ResponseResult<String> editForPur(@RequestBody List<CompanyVo> companys) {
        this.validate(companys);
        for (CompanyVo company : companys) {
            String id = company.getId();
            String companyRetrieve = company.getCompanyRetrieve();
            String taxCode = company.getTaxCode();
            BigDecimal taxRate = company.getTaxRate();
            Company c = new Company();
            c.setId(id);
            c.setTaxCode(taxCode);
            c.setTaxRate(taxRate);
            c.setCompanyRetrieve(companyRetrieve);
            this.companyService.updateByPrimaryKeySelective(c);
        }

        return ResponseResult.success();
    }

    /**
     * 保存之前进行校验
     * @param companys
     */
    private void validate(List<CompanyVo> companys) {
        Assert.isNotEmpty(companys,"请选择需要操作的数据！");
        for (CompanyVo company : companys) {
            String companyRetrieve = company.getCompanyRetrieve();
            Assert.isNotBlank(companyRetrieve,"供应商检索项不能为空！");
            String taxCode = company.getTaxCode();
            Assert.isNotBlank(taxCode,"税码不能为空");
            String id = company.getId();
            Assert.isNotBlank(id,"请选择需要操作的供应商数据！");
        }
    }


    @ApiOperation(httpMethod = "POST", value = "供应商注册")
    @RequestMapping("front/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Company company, @RequestParam String mailVerifCode,
            HttpSession session) {
        if (company == null) {
            throw new CommonException("公司注册信息", "base_canot_be_null", "注册信息");
        }

        if (StringUtils.isBlank(company.getCompanyFullName())) {
            throw new CommonException("公司名称不能为空", "base_canot_be_null", "公司名称");
        }

        if (company.getCompanyFullName().length() > 255
                || !company.getCompanyFullName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(（\\)）]+")) {
            throw new CommonException("格式不正确", "base_invaild_format", "企业全称");
        }

        if (StringUtils.isBlank(company.getMobilephone())) {
            throw new CommonException("手机号码不能为空", "base_canot_be_null", "手机号码");
        }

        // 获取session中的邮箱地址
        String emailAddress = (String) session.getAttribute("mailVerifAddress");
        if (StringUtils.isBlank(emailAddress)) {
            throw new CommonException("session中没邮箱地址");
        }
        if (!emailAddress.equals(company.getEmail())) {
            throw new CommonException("你输入的邮箱地址与发送验证码的邮箱地址不相符，请重新输入！");
        }

        String mailVerfCodeInSession = (String) session.getAttribute("mailVerifCode");
        if (StringUtils.isBlank(mailVerifCode) || StringUtils.isBlank(mailVerfCodeInSession)
                || !mailVerfCodeInSession.equals(mailVerifCode)) {
            throw new CommonException("邮箱验证码错误！");
        }

        String code = companyService.register(ProjectUtils.getProject(), company);

        return ResponseResult.success(code);
    }

    @ApiOperation(httpMethod = "POST", value = "编辑企业信息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Company company) {
        company.setProjectId(ProjectUtils.getProjectId());
        this.companyService.modifyObj(company);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除企业信息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        this.companyService.deleteObjById(id);
        return ResponseResult.success();
    }

   /* @ApiOperation(httpMethod = "GET", value = "分页查询企业下的供应商")
    @RequestMapping("service/findSupplyCompanyByPage")
    @ResponseBody
    public ResponseResult<PageView<Company>> findSupplyCompanyByPage(
            @ApiParam(value = "分页索引", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页的数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<QueryParam> queryParams) {

        CompanyExample example = new CompanyExample();
        example.setPageView(new PageView<Company>(pageNo, pageSize));

        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }

        PageView<Company> pageData = this.companyService.querySupplerCompanies(
                CompanyUtils.currentCompanyId(), example);
        // 把供应商的用户列表也带出来
        if (CollectionUtils.isEmpty(pageData.getQueryResult())) {
            return ResponseResult.success(pageData);
        }

        for (Company company : pageData.getQueryResult()) {

            CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
            CompanyUserRefExample.Criteria companyUserRefExampleCriteria = companyUserRefExample
                    .createCriteria();
            companyUserRefExampleCriteria.andProjectIdEqualTo(company.getProjectId());
            companyUserRefExampleCriteria.andCompanyIdEqualTo(company.getId());
            List<CompanyUserRef> companyUserRefList = this.companyUserRefService
                    .queryAllObjByExample(companyUserRefExample);
            if (CollectionUtils.isEmpty(companyUserRefList)) {
                continue;
            }

            List<String> userIds = new ArrayList<>();
            for (CompanyUserRef userRef : companyUserRefList) {
                userIds.add(userRef.getUserId());
            }
            UserExample userExample = new UserExample();
            userExample.createCriteria().andIdIn(userIds).andIsEnableEqualTo(Constant.YES_INT);
            // 把供应商下对应的用户信息拿出来
            company.setUserList(this.userService.queryAllObjByExample(userExample));
        }

        return ResponseResult.success(pageData);

    }*/

    @ApiOperation(httpMethod = "GET", value = "分页查询企业下的供应商")
    @RequestMapping("service/findSupplyCompanyByPage")
    @ResponseBody
    public ResponseResult<PageView<Company>> findSupplyCompanyByPage(
            @RequestParam(defaultValue = "qualified") String roleEnum,
            @ApiParam(value = "分页索引", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页的数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<QueryParam> queryParams) {

        CompanyExample example = new CompanyExample();
        example.setPageView(new PageView<Company>(pageNo, pageSize));

        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }

        //PageView<Company> pageData = this.companyService.querySupplerCompanies(CompanyUtils.currentCompanyId(), example);

        // 获取采购商ID
        String purCompanyId = ProjectUtils.getProject().getCompanyId();

        //添加sap编码不能为空
        criteria.andCompanySapCodeIsNotNull();

        PageView<Company> pageData = companyService.querySupplerCompanyHaveSap(purCompanyId, example, roleEnum);

        // 把供应商的用户列表也带出来
        if (CollectionUtils.isEmpty(pageData.getQueryResult())) {
            return ResponseResult.success(pageData);
        }
        for (Company company : pageData.getQueryResult()) {

            CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
            CompanyUserRefExample.Criteria companyUserRefExampleCriteria = companyUserRefExample
                    .createCriteria();
            companyUserRefExampleCriteria.andProjectIdEqualTo(company.getProjectId());
            companyUserRefExampleCriteria.andCompanyIdEqualTo(company.getId());
            List<CompanyUserRef> companyUserRefList = this.companyUserRefService
                    .queryAllObjByExample(companyUserRefExample);
            if (CollectionUtils.isEmpty(companyUserRefList)) {
                continue;
            }

            List<String> userIds = new ArrayList<>();
            for (CompanyUserRef userRef : companyUserRefList) {
                userIds.add(userRef.getUserId());
            }
            UserExample userExample = new UserExample();
            userExample.createCriteria().andIdIn(userIds).andIsEnableEqualTo(Constant.YES_INT);
            // 把供应商下对应的用户信息拿出来
            company.setUserList(this.userService.queryAllObjByExample(userExample));
        }
        return ResponseResult.success(pageData);

    }

    @ApiOperation(httpMethod = "GET", value = "分页查询企业下的供应商主数据")
    @RequestMapping("service/findKeySupplierCompanyByPage")
    @ResponseBody
    public ResponseResult<PageView<Company>> findKeySupplierCompanyByPage(
            @RequestParam(defaultValue = "qualified") String roleEnum,
            @ApiParam(value = "分页索引", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页的数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件") @RequestBody(required = false) QueryParamWapper queryParams) {

        CompanyExample example = new CompanyExample();
        example.setPageView(new PageView<>(pageNo, pageSize));

        CompanyExample.Criteria criteria = example.createCriteria();
        if (queryParams!=null) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }
        // 获取采购商ID
        String purCompanyId = ProjectUtils.getProject().getCompanyId();

        //添加sap编码不能为空
        criteria.andCompanySapCodeIsNotNull();

        PageView<Company> pageData = companyService.querySupplerCompanyHaveSap(purCompanyId, example, roleEnum);

        // 把供应商的用户列表也带出来
        if (CollectionUtils.isEmpty(pageData.getQueryResult())) {
            return ResponseResult.success(pageData);
        }
        for (Company company : pageData.getQueryResult()) {

            CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
            CompanyUserRefExample.Criteria companyUserRefExampleCriteria = companyUserRefExample
                    .createCriteria();
            companyUserRefExampleCriteria.andCompanyIdEqualTo(company.getId());
            companyUserRefExampleCriteria.andProjectIdEqualTo(company.getProjectId());
            List<CompanyUserRef> companyUserRefList = this.companyUserRefService
                    .queryAllObjByExample(companyUserRefExample);
            if (CollectionUtils.isEmpty(companyUserRefList)) {
                continue;
            }

            List<String> userIds = new ArrayList<>();
            for (CompanyUserRef userRef : companyUserRefList) {
                userIds.add(userRef.getUserId());
            }
            // 把供应商下对应的用户信息拿出来
            UserExample userExample = new UserExample();
            userExample.createCriteria().andIdIn(userIds).andIsEnableEqualTo(Constant.YES_INT);
            company.setUserList(this.userService.queryAllObjByExample(userExample));
        }
        return ResponseResult.success(pageData);

    }

    @ApiOperation(httpMethod = "GET", value = "分页查询企业下的销售商")
    @RequestMapping("service/findSaleCompaniesByPage")
    @ResponseBody
    public ResponseResult<PageView<Company>> findSaleCompaniesByPage(
            @ApiParam(value = "分页索引", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页的数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<QueryParam> queryParams) {

        CompanyExample example = new CompanyExample();
        example.setPageView(new PageView<Company>(pageNo, pageSize));
        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        String companyId = CompanyUtils.currentCompanyId();

        PageView<Company> pageData = this.companyService.queryPurchaseCompaniesByPage(companyId, example);
        return ResponseResult.success(pageData);

    }

    @ApiOperation(httpMethod = "GET", value = "查询当前企业信息")
    @RequestMapping("service/findCurrentCompany")
    @ResponseBody
    public ResponseResult<Company> findCurrentCompany() {
        Company company = CompanyUtils.currentCompany();
        // 地址不再做关联
        // List<CompanyAddress> companyAddressList = new ArrayList<CompanyAddress>();
        // List<CompanyAddress>
        // companyAddressList=this.companyAddressService.queryByCompanyId(company.getId());
        // company.setCompanyAddressList(companyAddressList);
        return ResponseResult.success(company);
    }

    @ApiOperation(httpMethod = "POST", value = "添加企业伙伴")
    @RequestMapping("service/addCompanyAsPartner")
    @ResponseBody
    public ResponseResult<String> addCompanyAsPartner(@RequestBody CompanyPartner companyPartner) {
        if (companyPartner.getPartner() == null) {
            throw new CommonException("企业信息不能为空", "base_canot_be_null", "企业信息");
        }

        if (StringUtils.isBlank(companyPartner.getPartner().getId())) {

        }
        if (StringUtils.isBlank(companyPartner.getPartnerRoleCode())) {
            throw new CommonException("伙伴角色编码不能为空", "base_canot_be_null", "伙伴角色编码");
        }

        companyPartner.setCompanyId(CompanyUtils.currentCompanyId());
        companyPartner.setProjectId(ProjectUtils.getProjectId());
        this.companyService.addCompanyAsSupplier(companyPartner);

        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "GET", value = "启用/禁止企业信息")
    @RequestMapping("service/isEnable")
    @ResponseBody
    public ResponseResult<Integer> isEnable(
            @ApiParam(value = "企业id") @RequestParam(required = true) String id,
            @ApiParam(value = "启用传1,禁用传0") Integer isEnable) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("Id为，空不能禁用或启用", "id_is_blank");
        }
        int result = this.companyService.isEnable(id, isEnable);
        return ResponseResult.success(result);
    }

    @ApiOperation(httpMethod = "POST", value = "给供应商添加账号")
    @RequestMapping("service/addSupplierIntoUser")
    @ResponseBody
    public ResponseResult<String> addSupplierIntoUser(
            @ApiParam(value = "供应商ID") @RequestParam(required = true) String supplierId,
            @ApiParam(value = "供应商登陆账号名称") @RequestBody User user) {

        if (StringUtils.isBlank(supplierId)) {
            throw new CommonException("Id为空", "id_is_blank");
        }
        if (StringUtils.isBlank(user.getLoginName())) {
            throw new CommonException("用户账号名不能为空", "base_canot_be_null", "用户账号名");
        }
        if (StringUtils.isBlank(user.getPassword())) {
            throw new CommonException("用户账号密码不能为空", "base_canot_be_null", "用户账号密码不");
        }
        if (StringUtils.isBlank(user.getMobilePhone())) {
            throw new CommonException("用户手机号不能为空", "base_canot_be_null", "用户手机号");
        }
        if (StringUtils.isBlank(user.getEmail())) {
            throw new CommonException("用户邮箱不能为空", "base_canot_be_null", "用户邮箱");
        }
        user.setProjectCode(ProjectUtils.getProject().getProjectCode());
        Company company = this.companyService.queryObjById(supplierId);
        if (company == null) {
            throw new CommonException("供应商 '" + supplierId + "不存在", "do_not_exists", "供应商");
        }

        this.companyUserRefService.addSupplierIntoUser(company, user);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "给采购用户添加供应商账号关系")
    @RequestMapping("service/addSupplierIntoPurchaser")
    @ResponseBody
    public ResponseResult<String> addSupplierIntoPurchaser(
            @ApiParam(value = "用户ID") @RequestParam(required = true) String userId,
            @ApiParam(value = "供应商列表") @RequestBody List<Company> companyList) {

        companyPurRefService.addSupplierIntoPurchaser(userId, CompanyUtils.currentCompany(), companyList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "GET", value = "查询用户对应供应商以及采购商用户")
    @RequestMapping("service/findFriendGroup")
    @ResponseBody
    public ResponseResult<List<FriendGroup>> findFriendGroup() {
        // 当前用户找到当前公司
        String userId = SpringSecurityUtils.getLoginUserId();

        // 查询供应商用户
        // CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
        // CompanyUserRefExample.Criteria companyUserRefExampleCriteria =
        // companyUserRefExample.createCriteria();
        // companyUserRefExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        // companyUserRefExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        // List<FriendGroup> supplierUserList =
        // companyUserRefService.findSupplierUser(companyUserRefExample);
        List<FriendGroup> supplierUserList = this.companyPurRefService.querySupplyFriendGroup(userId);

        // 查询采购商用户
        // CompanyPurRefExample companyPurRefExample = new CompanyPurRefExample();
        // CompanyPurRefExample.Criteria companyPurRefExampleCriteria =
        // companyPurRefExample.createCriteria();
        // companyPurRefExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        // companyPurRefExampleCriteria.andUserIdEqualTo(userId);
        // List<FriendGroup> purchaseUserList =
        // companyPurRefService.findPurchaseUser(companyPurRefExample);
        List<FriendGroup> purchaseUserList = companyPurRefService.queryPurchaseFriendGroup(CompanyUtils
                .currentCompanyId());

        // 合并这俩个集合
        List<FriendGroup> friendGroupList = new ArrayList<FriendGroup>();
        if (CollectionUtils.isNotEmpty(purchaseUserList)) {
            friendGroupList.addAll(purchaseUserList);
        }
        if (CollectionUtils.isNotEmpty(supplierUserList)) {
            friendGroupList.addAll(supplierUserList);
        }
        return ResponseResult.success(friendGroupList);
    }

    @ApiOperation(httpMethod = "GET", value = "查询企业下全部的供应商")
    @RequestMapping("service/findAllSupplyCompany")
    @ResponseBody
    public ResponseResult<List<Company>> findAllSupplyCompany(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<QueryParam> queryParams) {

        // 当前公司
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        // 当前公司下的供应商
        // CompanyPartnerExample partnerExample = new CompanyPartnerExample();
        // partnerExample.createCriteria().andProjectIdEqualTo(ProjectUtils.getProjectId())
        // .andCompanyIdEqualTo(CompanyUtils.currentCompanyId());

        // 根据俩个条件进行查询
        List<Company> companyList = this.companyService.queryAllSupplerCompanies(
                CompanyUtils.currentCompanyId(), example);
        return ResponseResult.success(companyList);
    }

    @ApiOperation(httpMethod = "GET", value = "查询当前采购员，管理的供应商")
    @RequestMapping("service/findSupCompanyOfCurrentUser")
    @ResponseBody
    public ResponseResult<List<Company>> findSupCompanyOfCurrentUser(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<QueryParam> queryParams) {
        List<Company> companyList = CompanyUtils.getSupCompanyOfCurrentUser();
        return ResponseResult.success(companyList);
    }



    @ApiOperation(value = "查询当前登录人的公司的帐号", httpMethod = "GET")
    @RequestMapping("service/findByCompany")
    @ResponseBody
    public ResponseResult<PageView<User>> findByPage(
            @ApiParam(value = "所在页", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<QueryParam> queryParams) {

        List<String> userIdList = companyUserRefService.queryUserOfCompany(CompanyUtils.currentCompanyId());
        UserExample example = new UserExample();
        example.setPageView(new PageView<User>(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn(userIdList);
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }

        PageView<User> list = userService.queryObjByPage(example);
        return ResponseResult.success(list);
    }

    @ApiOperation(value = "查询当前登录人的公司的帐号（现在用的通用查询条件）", httpMethod = "POST")
    @RequestMapping("service/findUserByCurrentCompany")
    @ResponseBody
    public ResponseResult<PageView<User>> findUserByCurrentCompany(
            @ApiParam(value = "所在页", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {

        List<String> userIdList = companyUserRefService.queryUserOfCompany(CompanyUtils.currentCompanyId());
        UserExample example = new UserExample();
        example.setPageView(new PageView<User>(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn(userIdList);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        PageView<User> list = userService.queryObjByPage(example);
        return ResponseResult.success(list);
    }

    @ApiOperation(value = "查询当前登录人的公司的帐号", httpMethod = "GET")
    @RequestMapping("service/findUserBySupCompany")
    @ResponseBody
    public ResponseResult<PageView<User>> findUserBySupCompany(
            @ApiParam(value = "所在页", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<QueryParam> queryParams) {

        List<String> userIdList = companyUserRefService.queryUserOfCompany(CompanyUtils.currentCompanyId());
        UserExample example = new UserExample();
        example.setPageView(new PageView<User>(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andIdNotIn(userIdList);
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }

        PageView<User> list = userService.queryObjByPage(example);
        return ResponseResult.success(list);
    }

    @ApiOperation(httpMethod = "GET", value = "查询登录的供应商信息")
    @ApiImplicitParams({ @ApiImplicitParam(name = "supCompanySrmCode", required = false, value = "供应商SRM编码", paramType = "query", dataType = "String"), })
    @RequestMapping("service/findCompanyInformation")
    @ResponseBody
    public ResponseResult<Company> findCompany(@RequestParam(required = false) String supCompanySrmCode) {
    	Company company = null;
        if (StringUtils.isBlank(supCompanySrmCode)) {
           company = CompanyUtils.currentCompany();
        } else {
          company = this.companyService.queryCompanyByCode(supCompanySrmCode);
        }
        return ResponseResult.success(company);
    }

    @ApiOperation(httpMethod = "POST", value = "编辑企业基本信息")
    @RequestMapping("service/updateCompany")
    @ResponseBody
    public ResponseResult<Map<String, Integer>> updateCompany(@RequestBody Company company) {
    	Integer companyStatus = FinishFlagUtils.getFinishFlag(company);
        company.setFinishFlag(companyStatus);
        company.setCompanyFullName(null);
        
        this.companyService.modifyCompany(ProjectUtils.getProject(),company);
        Map<String, Integer> map = new HashMap<>(16);
        map.put("enterpriseBaseInfo", companyStatus);
        return ResponseResult.success(map);
    }

    @ApiOperation(httpMethod = "POST", value = "根据id保存供应商信息")
    @RequestMapping("service/saveCompanyById")
    @ResponseBody
    public ResponseResult<String> saveCompanyById(@RequestBody Company company) {
        this.companyService.updateByPrimaryKeySelective(company);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "供应商是否上线SRM")
    @RequestMapping("service/isEnableOnline")
    @ResponseBody
    public ResponseResult<String> isEnableOnline(@RequestParam String companyId) {
    	Assert.isNotBlank(companyId, "id为空，操作失败");
    	this.companyService.disableOnlineSrm(companyId);
        return ResponseResult.success();
    }

    // public static void main(String[] args) {
    // }
}