package com.els.base.company.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExtend;
import com.els.base.company.entity.CompanyExtendExample;
import com.els.base.company.service.CompanyExtendService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="企业信息扩展表")
@Controller
@RequestMapping("companyExtend")
public class CompanyExtendController {
    @Resource
    protected CompanyExtendService companyExtendService;

    @Resource
    protected CompanyService companyService;
    
    @ApiOperation(httpMethod="POST", value="创建企业信息扩展表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyExtend companyExtend, String companyId) {
    	Assert.isNotNull(companyExtend, "保存失败，数据不能为空");
    	if (StringUtils.isNotBlank(companyId)) {
    		Company company = companyService.queryObjById(companyId);
			companyExtend.setCompanyId(companyId);
			companyExtend.setCompanySrmCode(company.getCompanyCode());
		}else {
			companyExtend.setCompanyId(CompanyUtils.currentCompanyId());
			companyExtend.setCompanySrmCode(CompanyUtils.currentCompany().getCompanyCode());
		}
    	
    	if (StringUtils.isNotBlank(companyExtend.getId())) {
    		this.companyExtendService.modifyObj(companyExtend);
		}else {
			this.companyExtendService.addObj(companyExtend);
		}
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑企业信息扩展表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyExtend companyExtend) {
        Assert.isNotBlank(companyExtend.getId(), "id 为空，保存失败");
        this.companyExtendService.modifyObj(companyExtend);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除企业信息扩展表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.companyExtendService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询企业信息扩展表")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyExtend", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyExtend>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        CompanyExtendExample example = new CompanyExtendExample();
        example.setPageView(new PageView<CompanyExtend>(pageNo, pageSize));
        
        CompanyExtendExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<CompanyExtend> pageData = this.companyExtendService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="GET", value="查询供应商扩展表的详情")
    @ApiImplicitParams({ @ApiImplicitParam(name = "supCompanySrmCode", required = false, value = "供应商SRM编码", paramType = "query", dataType = "String"), })
    @RequestMapping("service/findCompanyExtend")
    @ResponseBody
    public ResponseResult<CompanyExtend> findCompanyExtend(@RequestParam(required = false) String supCompanySrmCode) {
        CompanyExtend companyExtend = null;
    	if (StringUtils.isBlank(supCompanySrmCode)) {
    		supCompanySrmCode = CompanyUtils.currentCompany().getCompanyCode();
        }
        // 根据供应商ID查询供应商扩展数据信息
        CompanyExtendExample example = new CompanyExtendExample();
        example.createCriteria().andCompanySrmCodeEqualTo(supCompanySrmCode);
        List<CompanyExtend> list = this.companyExtendService.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(list)) {
        	companyExtend = list.get(0);
        }
        return ResponseResult.success(companyExtend);
    }
}