package com.els.base.company.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.dao.CompanyPartnerMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jxl.write.WritableWorkbook;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletResponse;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.*;

/**
 * liuhongfeng
 * 仅用作供应商导入工作
 */
@Api(value = "供应商导入")
@Controller
@RequestMapping("importCompany")
public class CompanyImportController {

    private static Logger log= LoggerFactory.getLogger(CompanyImportController.class);
    @Autowired
    private CompanyService companyService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private UserService userService;
    @Autowired
    private CompanyUserRefService companyUserRefService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private CompanyPartnerMapper companyPartnerMapper;
    @Autowired
    private RoleService roleService;

    @ApiOperation(httpMethod = "POST", value = "下载供应商导入模板")
    @RequestMapping("service/downloadExcel")
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(HttpServletResponse response) {

        FileData excelFile = new FileData();
        try {
            excelFile.setProjectId(ProjectUtils.getProjectId());
            excelFile.setCompanyId(CompanyUtils.currentCompanyId());
            excelFile.setFileName("供应商导入模板.xls");
            excelFile.setFileSuffix("xls");
            excelFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
            excelFile = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")), excelFile);
            OutputStream outputStream = new FileOutputStream(excelFile.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, null,
                    "供应商导入模板", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return ResponseResult.success(excelFile);

    }

    @ApiOperation(httpMethod = "POST", value = "供应商导入")
    @RequestMapping("service/import")
    @Transactional
    @ResponseBody
    public ResponseResult<String> importCompany(MultipartHttpServletRequest request) {

        //1.获取导入的Exce表，并转成List数据
        List<Company> companyList = this.getCompanyFromExcel(request);

        //2.导入供应商主数据
        this.create(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), companyList);

        return ResponseResult.success();
    }


    private void create(Project project, Company purCompany, User loginUser, List<Company> companyList) {
        //过滤一下
        this.filterForCreate(companyList);

        //执行
        for (Company supCompany : companyList) {

            //创建或者更新供应商基本信息，并且返回新的供应商
            List<Company> list = this.getNewCompanies(purCompany, supCompany);

            //给这些供应商分配账号
            this.createUserForCompany(project, list);

            //插入供应商与采购上基本信息
            this.createRaForPurCompany(project, list);

        }
    }

    /**
     * 获取新的供应商并且更新供应商基本信息
     *
     * @param purCompany
     * @param supCompany
     * @return
     */
    private List<Company> getNewCompanies(Company purCompany, Company supCompany) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria()
                .andCompanySapCodeEqualTo(supCompany.getCompanySapCode())
                .andIsEnableEqualTo(Constant.YES_INT);

        List<Company> companies = this.companyService.queryAllObjByExample(companyExample);

        List<Company> list = new ArrayList<>();

        //如果已经存在的供应商，那么更新数据即可
        if (CollectionUtils.isNotEmpty(companies)) {
            Company company = companies.get(0);

            //更新信息 TODO

            this.companyService.modifyObj(company);

            //如果不存在的供应商，那么需要创建他们之间的一些关系
        } else {
            Company company = new Company();
            BeanUtils.copyProperties(supCompany, company);
            company.setPassword("edeade8c9f6b8b85f63bbe64f31fe25371809f02cd24278b");
            company.setId(null);
            company.setProjectId(purCompany.getProjectId());

            company.setCreateTime(new Date());
            company.setIsEnable(Constant.YES_INT);

            //生成srm编码
            String nextCompanyCode = generateCodeService.getNextCompanyCode();
            company.setCompanyCode(nextCompanyCode);
            //其他信息
            //this.companyService.insertSelective(company);
            this.companyService.addObjByImport(company);
            list.add(company);
        }
        return list;
    }


    /**
     * 插入供应商与采购上基本信息
     *
     * @param project
     * @param list
     */
    private void createRaForPurCompany(Project project, List<Company> list) {
        for (Company company : list) {
            CompanyPartner companyPartner = new CompanyPartner();
            companyPartner.setProjectId(project.getId());
            companyPartner.setCompanyId(project.getCompanyId());
            companyPartner.setPartnerCompanyId(company.getId());
            companyPartner.setPartnerCompanyName(company.getCompanyFullName());
            companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
            companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
            this.companyPartnerMapper.insertSelective(companyPartner);
        }
    }


    /**
     * 给供应商创建用户并分配
     *
     * @param project
     * @param list
     */
    private void createUserForCompany(Project project, List<Company> list) {

        for (Company company : list) {

            this.filterForCreateUser(company);

            // 3.插入供应商用户基本信息
            com.els.base.core.entity.user.User user = new com.els.base.core.entity.user.User();
            log.info("----" + company.getCompanySapCode());
            user.setLoginName(company.getCompanySapCode());
            user.setNickName(company.getCompanyFullName());
            user.setMobilePhone(company.getMobilephone());
            //user.setPassword(company.getPassword());
            user.setPassword("123456");
            user.setEmail(company.getEmail());

            //其他信息
            user.setCreateTime(new Date());
            user.setUpdateTime(new Date());
            user.setLastLoginTime(new Date());
            user.setIsEnable(Constant.YES_INT);
            if (project != null) {
                user.setProjectCode(project.getProjectCode());
            }
            this.userService.addObj(user);


            // 4.创建供应商与用户之间的关系
            UserExample userExample = new UserExample();
            userExample.createCriteria()
                    .andLoginNameEqualTo(user.getLoginName());
            List<com.els.base.core.entity.user.User> users = this.userService.queryAllObjByExample(userExample);
            if (CollectionUtils.isNotEmpty(users)) {
                CompanyUserRef ref = new CompanyUserRef();
                ref.setUserId(user.getId());
                ref.setProjectId(company.getProjectId());
                ref.setCompanyId(company.getId());
                if (StringUtils.isEmpty(company.getId())) {
                    CompanyExample companyExample = new CompanyExample();
                    companyExample.createCriteria()
                            .andCompanySapCodeEqualTo(company.getCompanySapCode())
                            .andIsEnableEqualTo(Constant.YES_INT);

                    List<Company> companies = this.companyService.queryAllObjByExample(companyExample);

                    //如果已经存在的供应商，那么更新数据即可
                    if (CollectionUtils.isNotEmpty(companies)) {
                        ref.setCompanyId(companies.get(0).getId());
                    }
                }
                ref.setCreateTime(new Date());
                this.companyUserRefService.addObj(ref);
            }

            //5. 给用户分配角色
            RoleExample roleExample = new RoleExample();
            roleExample.createCriteria()
                    .andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
            List<Role> roles = roleService.queryAllObjByExample(roleExample);
            if (CollectionUtils.isNotEmpty(list)) {
                for (Role role : roles) {
                    UserRole t = new UserRole();
                    t.setUserId(user.getId());
                    t.setRoleId(role.getId());
                    t.setCreateTime(new Date());
                    userRoleService.addObj(t);
                }
            }
        }
    }

    private void filterForCreateUser(Company company) {

        //email检查
        String email = company.getEmail();
        if (StringUtils.isNotBlank(email)) {
            UserExample userExample = new UserExample();
            userExample.createCriteria()
                    .andEmailEqualTo(email);
            List<com.els.base.core.entity.user.User> users = this.userService.queryAllObjByExample(userExample);
            if (CollectionUtils.isNotEmpty(users)) {
                throw new CommonException(email + "已经存在，请检查");
            }

        }

        //手机号检查
        String mobilePhone = company.getMobilephone();
        if (StringUtils.isNotBlank(mobilePhone)) {
            UserExample userExample = new UserExample();
            userExample.createCriteria()
                    .andMobilePhoneEqualTo(mobilePhone);
            List<com.els.base.core.entity.user.User> users = this.userService.queryAllObjByExample(userExample);
            if (CollectionUtils.isNotEmpty(users)) {
                throw new CommonException(mobilePhone + "已经存在，请检查");
            }
        }
    }


    /**
     * 过滤一下是否能创建供应商
     *
     * @param companyList
     */
    private void filterForCreate(List<Company> companyList) {
        Assert.isNotEmpty(companyList, "供应商信息不能为空！");
        for (Company company : companyList) {
            Assert.isNotBlank(company.getCompanySapCode(), "供应商SAP编码不能为空！");
            Assert.isNotBlank(company.getCompanyName(), "供应商简称不能为空！");
            Assert.isNotBlank(company.getCompanyFullName(), "供应商全称不能为空！");
            Assert.isNotBlank(company.getMobilephone(), "手机号不能为空！");
            Assert.isNotBlank(company.getEmail(), "电子邮箱不能为空！");

        }
    }


    public static List<TitleAndModelKey> createExcelHeader() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("名称", "companyFullName", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("公司代码", "companySapCode", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购组织", "purchasingGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("简称", "companyName", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("街道/门牌号", "address"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("国家", "country"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("地区", "city"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("手机号码", "mobilephone", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("固定电话", "telephone"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("传真", "fax"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("E-mail", "email", true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("组代码", "groupCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("代表名称", "delegateType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("业务类型", "businessType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工业类型", "industrialType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("行业类型编码", "industryCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("行业类型描述", "industryDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("外部制造商", "externalManufacturer"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("统驭科目", "reconciliationAccountCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("付款条件", "payConditionsCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单货币", "orderCurren"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("国际贸易条件", "internationalTradeCondition"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("销售员", "salesman"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("销售员联系号码", "salesmanPhone"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("基于收货的发票验证", "invoiceVerify"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("自动建立采购订单", "automaticPurchaseOrder"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购员", "purchasingStaff"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("计划交付时间", "plannedDeliveryTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应属性", "supplyProperties"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商税率", "taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商税码", "taxCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商检索项", "companyRetrieve"));
        return titleAndModelKeys;
    }

    /**
     * 从Excel表格获取供应商
     *
     * @param request
     * @return
     */
    public List<Company> getCompanyFromExcel(MultipartHttpServletRequest request) {
        Map<String, MultipartFile> fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
        List<Company> list = new ArrayList<>();
        try {
            list = ExcelUtils.importExcelDataToMap(file.getInputStream(), 0, 1, 0, titleAndModelKeys, Company.class);
        } catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("导入异常：" + e.getMessage());
        }
        return list;
    }

    /**
     * 校验文件
     *
     * @param fileMap
     * @return
     */
    public MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("只接受单个文件导入");
        }
        Set<String> fileKeySet = fileMap.keySet();// 获取所有的key集合
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".xls")) {
            throw new CommonException("导入文件的格式不正确，目前只支持xls");
        }
        return file;
    }


}