package com.els.base.company.web.controller;

import com.els.base.company.entity.KnManageFile;
import com.els.base.company.entity.KnManageFileExample;
import com.els.base.company.service.KnManageFileService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value = "KN管理资料表")
@Controller
@RequestMapping("knManageFile")
public class KnManageFileController {
    @Resource
    protected KnManageFileService knManageFileService;

    @ApiOperation(httpMethod = "POST", value = "创建KN管理资料表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody KnManageFile knManageFile) {
        this.knManageFileService.addObj(knManageFile);
        return ResponseResult.success(knManageFile.getId());
    }

    @ApiOperation(httpMethod = "POST", value = "编辑KN管理资料表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody KnManageFile knManageFile) {
        Assert.isNotBlank(knManageFile.getId(), "id 为空，保存失败");
        this.knManageFileService.modifyObj(knManageFile);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "编辑KN管理资料表")
    @RequestMapping("service/editAll")
    @ResponseBody
    public ResponseResult<String> editAll(@RequestBody List<KnManageFile> knManageFileList) {
        Assert.isNotEmpty(knManageFileList, "data 为空，保存失败");
        this.knManageFileService.modifyAllObjByCompanyCode(knManageFileList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除KN管理资料表")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required = true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        KnManageFileExample example = new KnManageFileExample();
        example.createCriteria().andIdIn(ids);
        this.knManageFileService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除KN管理资料表")
    @RequestMapping("service/deleteObjById")
    @ResponseBody
    public ResponseResult<String> deleteObjById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.knManageFileService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "根据id查询KN管理资料表")
    @RequestMapping("service/queryObjById")
    @ResponseBody
    public ResponseResult<KnManageFile> queryObjById(@RequestParam(required = true) String id) {
        Assert.isNotBlank(id, "查询失败,id不能为空");
        KnManageFile knManageFile = this.knManageFileService.queryObjById(id);
        return ResponseResult.success(knManageFile);
    }

    @ApiOperation(httpMethod = "POST", value = "查询KN管理资料表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"),
            @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"),
            @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 KnManageFile", paramType = "body", dataType = "QueryParamWapper")
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<KnManageFile>> findByPage(
            @RequestParam(defaultValue = "0") int pageNo,
            @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper wapper) {
        KnManageFileExample example = new KnManageFileExample();
        example.setPageView(new PageView<KnManageFile>(pageNo, pageSize));

        KnManageFileExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<KnManageFile> pageData = this.knManageFileService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "查询KN管理资料表")
    @RequestMapping("service/findAllObj")
    @ResponseBody
    public ResponseResult<List<KnManageFile>> findAllObj(
            @RequestBody(required = false) QueryParamWapper wapper) {
        KnManageFileExample example = new KnManageFileExample();
        KnManageFileExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        List<KnManageFile> knManageFileList = this.knManageFileService.queryAllObjByExample(example);
        return ResponseResult.success(knManageFileList);
    }

    @ApiOperation(httpMethod = "POST", value = "根据SRMCode查询KN管理资料表")
    @RequestMapping("service/findKnMngBySrmCode")
    @ResponseBody
    public ResponseResult<List<KnManageFile>> findKnMngBySrmCode(
            @RequestParam(required = true) String companyCode) {
        KnManageFileExample example = new KnManageFileExample();
        KnManageFileExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyCodeEqualTo(companyCode);
        List<KnManageFile> knManageFileList = this.knManageFileService.queryAllObjByExample(example);
        return ResponseResult.success(knManageFileList);
    }

    @ApiOperation(httpMethod = "GET", value = "KN资料证书有效期超期预警")
    @RequestMapping("service/outTimeReply")
    @ResponseBody
    public ResponseResult<String> outTimeReply() {
        this.knManageFileService.outTimeReply();
        return ResponseResult.success();
    }
}