package com.els.base.company.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * Created by LiBing on 2014-07-17 14:16
 */
@Api("权限控制")
@Controller("companyOperatorController")
@RequestMapping("rightForCompany")
public class OperatorController {

	@Resource
	private RoleRightService rightService;

	@Resource
	private RoleService roleService;

	@ApiOperation(value = "对角色授权或取消授权", httpMethod = "POST")
	@RequestMapping("service/authorizedOperator")
	@ResponseBody
	public ResponseResult<String> authorizedOperator(@ApiParam(value = "角色id") @RequestParam String roleId,
			@RequestBody List<RoleRight> rights) {

		
		Role role = this.roleService.queryObjById(roleId);
		if (role == null) {
			throw new CommonException("该数据不存在", "do_not_exists", "角色数据");
		}
		
		if (CompanyUtils.currentCompany().equals(role.getCompanyId())) {
			throw new CommonException("该角色不是当前企业的创建，无法更改权限", "do_not_exists", "角色数据");
		}

		if (Role.ROLE_LEVEL_SYS.equals(role.getRoleLevel()) && !SpringSecurityUtils.isManagerLoginUser()) {
			throw new CommonException("该角色是系统角色无法修改", "can_not_delete_sys_role");
		}

		this.rightService.authorized(roleId, rights);

		return ResponseResult.success();
	}
}
