package com.els.base.company.web.controller;

import com.els.base.company.entity.SupplyGoodsRef;
import com.els.base.company.entity.SupplyGoodsRefExample;
import com.els.base.company.service.SupplyGoodsRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商供货类型")
@Controller
@RequestMapping("supplyGoodsRef")
public class SupplyGoodsRefController {
    @Resource
    protected SupplyGoodsRefService supplyGoodsRefService;

    @ApiOperation(httpMethod="POST", value="创建供应商供货类型")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody SupplyGoodsRef supplyGoodsRef) {
        this.supplyGoodsRefService.addObj(supplyGoodsRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑供应商供货类型")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody SupplyGoodsRef supplyGoodsRef) {
        if (StringUtils.isBlank(supplyGoodsRef.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.supplyGoodsRefService.modifyObj(supplyGoodsRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除供应商供货类型")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.supplyGoodsRefService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商供货类型")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 SupplyGoodsRef", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<SupplyGoodsRef>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        SupplyGoodsRefExample example = new SupplyGoodsRefExample();
        example.setPageView(new PageView<SupplyGoodsRef>(pageNo, pageSize));
        
        SupplyGoodsRefExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<SupplyGoodsRef> pageData = this.supplyGoodsRefService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}