/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.event.listener;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.event.CompanyCreatedSuccessEvent;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CompanyCreatedSuccessListener
implements ApplicationListener<CompanyCreatedSuccessEvent> {
    @Resource
    private UserService userService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ProjectService projectService;

    @Transactional
    public void onApplicationEvent(CompanyCreatedSuccessEvent event) {
        Company company = (Company)event.getSource();
        Project project = (Project)this.projectService.queryObjById((Object)company.getProjectId());
        if (project == null || StringUtils.isBlank((String)project.getProjectCode())) {
            throw new CommonException("ProjectCode\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"ProjectCode"});
        }
        User t = new User();
        t.setEmail(company.getEmail());
        t.setMobilePhone(company.getMobilephone());
        t.setLoginName(company.getCompanyCode());
        t.setPassword("123456");
        t.setIsEnable(Constant.YES_INT);
        t.setProjectCode(project.getProjectCode());
        try {
            this.userService.addObj((Serializable)t);
        }
        catch (Exception e) {
            throw new CommonException("\u8bf7\u6c42\u5931\u8d25", "base_fail");
        }
        CompanyUserRef userRef = new CompanyUserRef();
        userRef.setCompanyId(company.getId());
        userRef.setProjectId(company.getProjectId());
        userRef.setUserId(t.getId());
        this.companyUserRefService.addObj(userRef);
    }
}

