/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.CompanySapRelationMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanySapRelation;
import com.els.base.company.entity.CompanySapRelationExample;
import com.els.base.company.service.CompanySapRelationService;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="defaultCompanySapRelationService")
public class CompanySapRelationServiceImpl
implements CompanySapRelationService {
    @Resource
    protected CompanySapRelationMapper companySapRelationMapper;
    @Resource
    protected CompanyService companyService;

    @Override
    @Cacheable(value={"companySapRelation"}, keyGenerator="redisKeyGenerator")
    public CompanySapRelation findBySrmCodeAndSapCode(String srmCode, String sapCode) {
        Assert.isNotBlank((String)srmCode, (String)"SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)sapCode, (String)"SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CompanySapRelationExample companySapRelationExample = new CompanySapRelationExample();
        companySapRelationExample.createCriteria().andCompanyCodeEqualTo(srmCode).andSapSupplierCodeEqualTo(sapCode);
        List<CompanySapRelation> companySapRelations = this.companySapRelationMapper.selectByExample(companySapRelationExample);
        Assert.isNotEmpty(companySapRelations, (String)"\u91c7\u8d2d\u5458\u6ca1\u6709\u5728\u4f9b\u5e94\u5546\u7f16\u7801\u7ba1\u7406\u91cc\u9762\u7ef4\u62a4\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u8d1f\u8d23\u4eba\uff0c\u8c22\u8c22\uff01");
        return companySapRelations.get(0);
    }

    @CacheEvict(value={"companySapRelation"}, allEntries=true)
    public void addObj(CompanySapRelation t) {
        if (StringUtils.isEmpty((Object)t.getSapSupplierCode())) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)t.getCompanyCode())) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e3a\u7a7a");
        }
        if (t.getSapSupplierCode().length() > 32) {
            throw new CommonException("\u4f9b\u5e94\u5546SAP\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e32");
        }
        if (t.getCompanyCode().length() > 32) {
            throw new CommonException("\u4f9b\u5e94\u5546SRM\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e32");
        }
        Company company = this.checkCompanyCodeIfExist(t.getCompanyCode());
        if (company == null) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546SRM\u7f16\u7801[" + t.getCompanyCode() + "]\u4e0d\u5b58\u5728\u7cfb\u7edf");
        }
        boolean flag = this.checkSapSupplierCodeIfExist(t.getSapSupplierCode(), null);
        if (flag) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546SAP\u7f16\u7801[" + t.getSapSupplierCode() + "]\u5df2\u7ecf\u5b58\u5728\u7cfb\u7edf");
        }
        t.setCompanyName(company.getCompanyName());
        t.setCompanyFullName(company.getCompanyFullName());
        this.companySapRelationMapper.insertSelective(t);
    }

    @CacheEvict(value={"companySapRelation"}, allEntries=true)
    public void deleteObjById(String id) {
        CompanySapRelation companySapRelation = this.queryObjById(id);
        boolean flag2 = this.checkSapSuppliterCodeIfExistData(companySapRelation.getCompanyCode());
        if (flag2) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546SAP\u7f16\u7801[" + companySapRelation.getSapSupplierCode() + "]\u5df2\u7ecf\u5728\u7cfb\u7edf\u751f\u4ea7\u4e86\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
        }
        this.companySapRelationMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companySapRelation"}, allEntries=true)
    public void modifyObj(CompanySapRelation t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        Assert.isNotBlank((String)t.getSapSupplierCode(), (String)"\u8be5\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e3a\u7a7a");
        Assert.isNotBlank((String)t.getCompanyCode(), (String)"\u8be5\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e3a\u7a7a");
        if (t.getSapSupplierCode().length() > 32) {
            throw new CommonException("\u4f9b\u5e94\u5546SAP\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e32");
        }
        if (t.getCompanyCode().length() > 32) {
            throw new CommonException("\u4f9b\u5e94\u5546SRM\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e32");
        }
        CompanySapRelation oldCompanySapRelation = this.queryObjById(t.getId());
        if (!oldCompanySapRelation.getCompanyCode().equals(t.getCompanyCode())) {
            throw new CommonException("\u5df2\u521b\u5efa\u7684SRM\u7f16\u7801\u4e0d\u80fd\u4fee\u6539\u4e86");
        }
        if (!oldCompanySapRelation.getSapSupplierCode().equals(t.getSapSupplierCode())) {
            throw new CommonException("\u5df2\u521b\u5efa\u7684SAP\u7f16\u7801\u4e0d\u80fd\u4fee\u6539\u4e86");
        }
        if (!(t.getCompanyFullName() != null && !t.getCompanyFullName().equals(oldCompanySapRelation.getCompanyFullName()) || t.getCompanyFullEnName() != null && !t.getCompanyFullEnName().equals(oldCompanySapRelation.getCompanyFullEnName()) || t.getTaxRate() != null && !t.getTaxRate().equals(oldCompanySapRelation.getTaxRate()))) {
            return;
        }
        Company company = this.checkCompanyCodeIfExist(t.getCompanyCode());
        if (company == null) {
            throw new CommonException("\u8be5\u4f9b\u5e94\u5546SRM\u7f16\u7801[" + t.getCompanyCode() + "]\u4e0d\u5b58\u5728\u7cfb\u7edf");
        }
        this.companySapRelationMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companySapRelation"}, keyGenerator="redisKeyGenerator")
    public CompanySapRelation queryObjById(String id) {
        return this.companySapRelationMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companySapRelation"}, key="'CompanySapRelationService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public List<CompanySapRelation> queryAllObjByExample(CompanySapRelationExample example) {
        return this.companySapRelationMapper.selectByExample(example);
    }

    @Cacheable(value={"companySapRelation"}, key="'CompanySapRelationService_' + #root.methodName + '_'+ T(com.els.base.utils.encryption.Md5Utils).md5Object(#example)")
    public PageView<CompanySapRelation> queryObjByPage(CompanySapRelationExample example) {
        PageView<CompanySapRelation> pageView = example.getPageView();
        pageView.setQueryResult(this.companySapRelationMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public boolean checkSapSupplierCodeIfExist(String sapSupplierCode, String id) {
        List<CompanySapRelation> list;
        CompanySapRelationExample example = new CompanySapRelationExample();
        CompanySapRelationExample.Criteria criteria = example.createCriteria();
        criteria.andSapSupplierCodeEqualTo(sapSupplierCode);
        if (!StringUtils.isEmpty((Object)id)) {
            criteria.andIdNotEqualTo(id);
        }
        return (list = this.queryAllObjByExample(example)) != null && !list.isEmpty();
    }

    @Override
    public String findCompanyCodeBySapSupplierCode(String sapSupplierCode) {
        CompanySapRelation companySapRelation = this.findBySapSupplierCode(sapSupplierCode);
        if (companySapRelation == null) {
            return null;
        }
        return companySapRelation.getCompanyCode();
    }

    @Override
    @CacheEvict(value={"companySapRelation"}, allEntries=true)
    public void importFromExcel(List<CompanySapRelation> list) {
        if (list == null || list.isEmpty()) {
            throw new CommonException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        int index = 2;
        for (CompanySapRelation newEntity : list) {
            if (org.apache.commons.lang.StringUtils.isBlank((String)newEntity.getSapSupplierCode())) {
                throw new CommonException("\u7b2c" + index + "\u884c\u4f9b\u5e94\u5546SAP\u7f16\u7801\u6570\u636e\u4e3a\u7a7a");
            }
            if (org.apache.commons.lang.StringUtils.isBlank((String)newEntity.getCompanyCode())) {
                throw new CommonException("\u7b2c" + index + "\u884c\u4f9b\u5e94\u5546SRM\u7f16\u7801\u6570\u636e\u4e3a\u7a7a");
            }
            newEntity.setCompanyCode(newEntity.getCompanyCode().replace("\ufffd", ""));
            newEntity.setSapSupplierCode(newEntity.getSapSupplierCode().replace("\ufffd", ""));
            CompanySapRelation oldCompanySapRelation = this.findBySapSupplierCode(newEntity.getSapSupplierCode());
            if (oldCompanySapRelation == null) {
                this.addObj(newEntity);
                continue;
            }
            newEntity.setId(oldCompanySapRelation.getId());
            if (newEntity.getCompanyFullEnName() != null && newEntity.getCompanyFullEnName().trim().length() == 0) {
                newEntity.setCompanyFullEnName(null);
            }
            if (newEntity.getCompanyFullName() != null && newEntity.getCompanyFullName().trim().length() == 0) {
                newEntity.setCompanyFullName(null);
            }
            if (newEntity.getCompanyName() != null && newEntity.getCompanyName().trim().length() == 0) {
                newEntity.setCompanyName(null);
            }
            this.modifyObj(newEntity);
            ++index;
        }
    }

    @Override
    @CacheEvict(value={"companySapRelation"}, allEntries=true)
    public void deleteByIds(Set<String> ids) {
        if (ids == null || ids.isEmpty()) {
            throw new CommonException("\u53c2\u5165\u7684ID\u53c2\u6570\u4e3a\u7a7a");
        }
        for (String id : ids) {
            CompanySapRelation companySapRelation = this.queryObjById(id);
            boolean flag2 = this.checkSapSuppliterCodeIfExistData(companySapRelation.getCompanyCode());
            if (flag2) {
                throw new CommonException("\u8be5\u4f9b\u5e94\u5546SAP\u7f16\u7801[" + companySapRelation.getSapSupplierCode() + "]\u5df2\u7ecf\u5728\u7cfb\u7edf\u751f\u4ea7\u4e86\u4e1a\u52a1\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
            }
            this.companySapRelationMapper.deleteByPrimaryKey(id);
        }
    }

    @Override
    public List<String> findSapCodeByCompanyCode(String companyCode) {
        if (StringUtils.isEmpty((Object)companyCode)) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> sapCodes = new ArrayList<String>();
        CompanySapRelationExample example = new CompanySapRelationExample();
        CompanySapRelationExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyCodeEqualTo(companyCode);
        List<CompanySapRelation> list = this.queryAllObjByExample(example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (CompanySapRelation e : list) {
            sapCodes.add(e.getSapSupplierCode());
        }
        return sapCodes;
    }

    private CompanySapRelation findBySapSupplierCode(String sapSupplierCode) {
        CompanySapRelationExample example = new CompanySapRelationExample();
        CompanySapRelationExample.Criteria criteria = example.createCriteria();
        criteria.andSapSupplierCodeEqualTo(sapSupplierCode);
        List<CompanySapRelation> list = this.queryAllObjByExample(example);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private Company checkCompanyCodeIfExist(String code) {
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyCodeEqualTo(code);
        List list = this.companyService.queryAllObjByExample((IExample)example);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (Company)list.get(0);
    }

    private boolean checkSapSuppliterCodeIfExistData(String companyCode) {
        return true;
    }

    @CacheEvict(value={"companySapRelation"}, allEntries=true)
    public void addAll(List<CompanySapRelation> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        this.companySapRelationMapper.insertBatch(arg0);
    }

    @CacheEvict(value={"companySapRelation"}, allEntries=true)
    public void deleteByExample(CompanySapRelationExample arg0) {
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u5220\u9664\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        this.companySapRelationMapper.deleteByExample(arg0);
    }
}

