/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.KnManageFileMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.KnManageFile;
import com.els.base.company.entity.KnManageFileExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.service.KnManageFileService;
import com.els.base.company.vo.KnManageFileEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultKnManageFileService")
public class KnManageFileServiceImpl
implements KnManageFileService {
    @Resource
    protected KnManageFileMapper knManageFileMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyUserRefService companyUserRefService;

    @CacheEvict(value={"knManageFile"}, allEntries=true)
    public void addObj(KnManageFile t) {
        t.setCreateTime(new Date());
        this.knManageFileMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"knManageFile"}, allEntries=true)
    public void addAll(List<KnManageFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.knManageFileMapper.insertBatch(list);
    }

    @CacheEvict(value={"knManageFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.knManageFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"knManageFile"}, allEntries=true)
    public void deleteByExample(KnManageFileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.knManageFileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"knManageFile"}, allEntries=true)
    public void modifyObj(KnManageFile t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        t.setUpdateTime(new Date());
        this.knManageFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"knManageFile"}, keyGenerator="redisKeyGenerator")
    public KnManageFile queryObjById(String id) {
        return this.knManageFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"knManageFile"}, keyGenerator="redisKeyGenerator")
    public List<KnManageFile> queryAllObjByExample(KnManageFileExample example) {
        return this.knManageFileMapper.selectByExample(example);
    }

    @Cacheable(value={"knManageFile"}, keyGenerator="redisKeyGenerator")
    public PageView<KnManageFile> queryObjByPage(KnManageFileExample example) {
        PageView<KnManageFile> pageView = example.getPageView();
        pageView.setQueryResult(this.knManageFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void outTimeReply() {
        KnManageFileExample knManageFileExample = new KnManageFileExample();
        knManageFileExample.createCriteria().andCertificateValidityUntilLessThanOrEqualTo(new Date());
        List<KnManageFile> knManageFileList = this.knManageFileMapper.selectByExample(knManageFileExample);
        List companySapCodeList = knManageFileList.stream().map(KnManageFile::getSupCompanySapCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(companySapCodeList)) {
            for (int i = 0; i < companySapCodeList.size(); ++i) {
                CompanyExample example = new CompanyExample();
                example.createCriteria().andCompanySapCodeEqualTo((String)companySapCodeList.get(i));
                List companyList = this.companyService.queryAllObjByExample((IExample)example);
                User user = this.companyUserRefService.queryMainUserOfCompany(((Company)companyList.get(0)).getId());
                List<String> userOfCompanyList = this.companyUserRefService.queryUserOfCompany(((Company)companyList.get(0)).getId());
                userOfCompanyList.add(user.getId());
                KnManageFile knManageFile = new KnManageFile();
                Message message = Message.init((Object)knManageFile).setCompanyCode((String)companySapCodeList.get(i)).setSenderId("1").addReceiverIdList(userOfCompanyList).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(KnManageFileEnum.CERTIFICATE_OUT_TIME_REPLY.getDesc());
                MessageSendUtils.sendMessage((Message)message);
            }
        }
    }

    @Override
    @CacheEvict(value={"knManageFile"}, allEntries=true)
    public void modifyAllObjByCompanyCode(List<KnManageFile> knManageFileList) {
        List stringList = knManageFileList.stream().map(KnManageFile::getSupCompanyCode).distinct().collect(Collectors.toList());
        KnManageFileExample knManageFileExample = new KnManageFileExample();
        knManageFileExample.createCriteria().andSupCompanyCodeIn(stringList);
        this.knManageFileMapper.deleteByExample(knManageFileExample);
        for (int i = 0; i < knManageFileList.size(); ++i) {
            knManageFileList.get(i).setUpdateTime(new Date());
            this.knManageFileMapper.insertSelective(knManageFileList.get(i));
        }
    }
}

