/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.SupplyGoodsDictMapper;
import com.els.base.company.entity.SupplyGoodsDict;
import com.els.base.company.entity.SupplyGoodsDictExample;
import com.els.base.company.service.SupplyGoodsDictService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSupplyGoodsDictService")
public class SupplyGoodsDictServiceImpl
implements SupplyGoodsDictService {
    @Resource
    protected SupplyGoodsDictMapper supplyGoodsDictMapper;

    @CacheEvict(value={"supplyGoodsDict"}, allEntries=true)
    public void addObj(SupplyGoodsDict t) {
        this.supplyGoodsDictMapper.insertSelective(t);
    }

    @CacheEvict(value={"supplyGoodsDict"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supplyGoodsDictMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"supplyGoodsDict"}, allEntries=true)
    public void modifyObj(SupplyGoodsDict t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.supplyGoodsDictMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"supplyGoodsDict"}, keyGenerator="redisKeyGenerator")
    public SupplyGoodsDict queryObjById(String id) {
        return this.supplyGoodsDictMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"supplyGoodsDict"}, keyGenerator="redisKeyGenerator")
    public List<SupplyGoodsDict> queryAllObjByExample(SupplyGoodsDictExample example) {
        return this.supplyGoodsDictMapper.selectByExample(example);
    }

    @Cacheable(value={"supplyGoodsDict"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplyGoodsDict> queryObjByPage(SupplyGoodsDictExample example) {
        PageView<SupplyGoodsDict> pageView = example.getPageView();
        pageView.setQueryResult(this.supplyGoodsDictMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Cacheable(value={"supplyGoodsDict"}, keyGenerator="redisKeyGenerator")
    @Transactional
    public void addAll(List<SupplyGoodsDict> arg0) {
        if (CollectionUtils.isEmpty(arg0)) {
            return;
        }
        for (SupplyGoodsDict record : arg0) {
            this.supplyGoodsDictMapper.insertSelective(record);
        }
    }

    @Cacheable(value={"supplyGoodsDict"}, keyGenerator="redisKeyGenerator")
    public void deleteByExample(SupplyGoodsDictExample arg0) {
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u5220\u9664\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        this.supplyGoodsDictMapper.deleteByExample(arg0);
    }
}

