/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.FriendGroup;
import com.els.base.company.service.CompanyAddressService;
import com.els.base.company.service.CompanyExtendService;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.FinishFlagUtils;
import com.els.base.company.vo.CompanyVo;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f01\u4e1a\u4fe1\u606f")
@Controller
@RequestMapping(value={"company"})
public class CompanyController {
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected UserService userService;
    @Resource
    protected CompanyAddressService companyAddressService;
    @Resource
    protected CompanyExtendService companyExtendService;

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u7f16\u8f91\u4f01\u4e1a\u7a0e\u7387\uff0c\u7a0e\u7801\uff0c\u4f9b\u5e94\u5546\u68c0\u7d22\u9879\u4fe1\u606f")
    @RequestMapping(value={"service/editForPur"})
    @ResponseBody
    public ResponseResult<String> editForPur(@RequestBody List<CompanyVo> companys) {
        this.validate(companys);
        for (CompanyVo company : companys) {
            String id = company.getId();
            String companyRetrieve = company.getCompanyRetrieve();
            String taxCode = company.getTaxCode();
            BigDecimal taxRate = company.getTaxRate();
            Company c = new Company();
            c.setId(id);
            c.setTaxCode(taxCode);
            c.setTaxRate(taxRate);
            c.setCompanyRetrieve(companyRetrieve);
            this.companyService.updateByPrimaryKeySelective(c);
        }
        return ResponseResult.success();
    }

    private void validate(List<CompanyVo> companys) {
        Assert.isNotEmpty(companys, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\uff01");
        for (CompanyVo company : companys) {
            String companyRetrieve = company.getCompanyRetrieve();
            Assert.isNotBlank((String)companyRetrieve, (String)"\u4f9b\u5e94\u5546\u68c0\u7d22\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String taxCode = company.getTaxCode();
            Assert.isNotBlank((String)taxCode, (String)"\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            String id = company.getId();
            Assert.isNotBlank((String)id, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u4f9b\u5e94\u5546\u6570\u636e\uff01");
        }
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6ce8\u518c")
    @RequestMapping(value={"front/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Company company, @RequestParam String mailVerifCode, HttpSession session) {
        if (company == null) {
            throw new CommonException("\u516c\u53f8\u6ce8\u518c\u4fe1\u606f", "base_canot_be_null", new Object[]{"\u6ce8\u518c\u4fe1\u606f"});
        }
        if (StringUtils.isBlank((String)company.getCompanyFullName())) {
            throw new CommonException("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u516c\u53f8\u540d\u79f0"});
        }
        if (company.getCompanyFullName().length() > 255 || !company.getCompanyFullName().matches("[\\u4e00-\\u9fa5\\w\\-\\_\\(\uff08\\)\uff09]+")) {
            throw new CommonException("\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", new Object[]{"\u4f01\u4e1a\u5168\u79f0"});
        }
        if (StringUtils.isBlank((String)company.getMobilephone())) {
            throw new CommonException("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u624b\u673a\u53f7\u7801"});
        }
        String emailAddress = (String)session.getAttribute("mailVerifAddress");
        if (StringUtils.isBlank((String)emailAddress)) {
            throw new CommonException("session\u4e2d\u6ca1\u90ae\u7bb1\u5730\u5740");
        }
        if (!emailAddress.equals(company.getEmail())) {
            throw new CommonException("\u4f60\u8f93\u5165\u7684\u90ae\u7bb1\u5730\u5740\u4e0e\u53d1\u9001\u9a8c\u8bc1\u7801\u7684\u90ae\u7bb1\u5730\u5740\u4e0d\u76f8\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        String mailVerfCodeInSession = (String)session.getAttribute("mailVerifCode");
        if (StringUtils.isBlank((String)mailVerifCode) || StringUtils.isBlank((String)mailVerfCodeInSession) || !mailVerfCodeInSession.equals(mailVerifCode)) {
            throw new CommonException("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        String code = this.companyService.register(ProjectUtils.getProject(), company);
        return ResponseResult.success((Object)code);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f01\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Company company) {
        company.setProjectId(ProjectUtils.getProjectId());
        this.companyService.modifyObj(company);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f01\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        this.companyService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u5206\u9875\u67e5\u8be2\u4f01\u4e1a\u4e0b\u7684\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findSupplyCompanyByPage"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findSupplyCompanyByPage(@RequestParam(defaultValue="qualified") String roleEnum, @ApiParam(value="\u5206\u9875\u7d22\u5f15", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        criteria.andCompanySapCodeIsNotNull();
        PageView<Company> pageData = this.companyService.querySupplerCompanyHaveSap(purCompanyId, example, roleEnum);
        if (CollectionUtils.isEmpty((Collection)pageData.getQueryResult())) {
            return ResponseResult.success(pageData);
        }
        for (Company company : pageData.getQueryResult()) {
            CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
            CompanyUserRefExample.Criteria companyUserRefExampleCriteria = companyUserRefExample.createCriteria();
            companyUserRefExampleCriteria.andProjectIdEqualTo(company.getProjectId());
            companyUserRefExampleCriteria.andCompanyIdEqualTo(company.getId());
            List companyUserRefList = this.companyUserRefService.queryAllObjByExample((IExample)companyUserRefExample);
            if (CollectionUtils.isEmpty((Collection)companyUserRefList)) continue;
            ArrayList<String> userIds = new ArrayList<String>();
            for (CompanyUserRef userRef : companyUserRefList) {
                userIds.add(userRef.getUserId());
            }
            UserExample userExample = new UserExample();
            userExample.createCriteria().andIdIn(userIds).andIsEnableEqualTo(Constant.YES_INT);
            company.setUserList(this.userService.queryAllObjByExample((IExample)userExample));
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u5206\u9875\u67e5\u8be2\u4f01\u4e1a\u4e0b\u7684\u4f9b\u5e94\u5546\u4e3b\u6570\u636e")
    @RequestMapping(value={"service/findKeySupplierCompanyByPage"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findKeySupplierCompanyByPage(@RequestParam(defaultValue="qualified") String roleEnum, @ApiParam(value="\u5206\u9875\u7d22\u5f15", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) QueryParamWapper queryParams) {
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        CompanyExample.Criteria criteria = example.createCriteria();
        if (queryParams != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParams);
        }
        String purCompanyId = ProjectUtils.getProject().getCompanyId();
        criteria.andCompanySapCodeIsNotNull();
        PageView<Company> pageData = this.companyService.querySupplerCompanyHaveSap(purCompanyId, example, roleEnum);
        if (CollectionUtils.isEmpty((Collection)pageData.getQueryResult())) {
            return ResponseResult.success(pageData);
        }
        for (Company company : pageData.getQueryResult()) {
            CompanyUserRefExample companyUserRefExample = new CompanyUserRefExample();
            CompanyUserRefExample.Criteria companyUserRefExampleCriteria = companyUserRefExample.createCriteria();
            companyUserRefExampleCriteria.andCompanyIdEqualTo(company.getId());
            companyUserRefExampleCriteria.andProjectIdEqualTo(company.getProjectId());
            List companyUserRefList = this.companyUserRefService.queryAllObjByExample((IExample)companyUserRefExample);
            if (CollectionUtils.isEmpty((Collection)companyUserRefList)) continue;
            ArrayList<String> userIds = new ArrayList<String>();
            for (CompanyUserRef userRef : companyUserRefList) {
                userIds.add(userRef.getUserId());
            }
            UserExample userExample = new UserExample();
            userExample.createCriteria().andIdIn(userIds).andIsEnableEqualTo(Constant.YES_INT);
            company.setUserList(this.userService.queryAllObjByExample((IExample)userExample));
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u5206\u9875\u67e5\u8be2\u4f01\u4e1a\u4e0b\u7684\u9500\u552e\u5546")
    @RequestMapping(value={"service/findSaleCompaniesByPage"})
    @ResponseBody
    public ResponseResult<PageView<Company>> findSaleCompaniesByPage(@ApiParam(value="\u5206\u9875\u7d22\u5f15", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        CompanyExample example = new CompanyExample();
        example.setPageView((PageView<Company>)new PageView(pageNo, pageSize));
        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        String companyId = CompanyUtils.currentCompanyId();
        PageView<Company> pageData = this.companyService.queryPurchaseCompaniesByPage(companyId, example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5f53\u524d\u4f01\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/findCurrentCompany"})
    @ResponseBody
    public ResponseResult<Company> findCurrentCompany() {
        Company company = CompanyUtils.currentCompany();
        return ResponseResult.success((Object)company);
    }

    @ApiOperation(httpMethod="POST", value="\u6dfb\u52a0\u4f01\u4e1a\u4f19\u4f34")
    @RequestMapping(value={"service/addCompanyAsPartner"})
    @ResponseBody
    public ResponseResult<String> addCompanyAsPartner(@RequestBody CompanyPartner companyPartner) {
        if (companyPartner.getPartner() == null) {
            throw new CommonException("\u4f01\u4e1a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u4f01\u4e1a\u4fe1\u606f"});
        }
        if (StringUtils.isBlank((String)companyPartner.getPartner().getId())) {
            // empty if block
        }
        if (StringUtils.isBlank((String)companyPartner.getPartnerRoleCode())) {
            throw new CommonException("\u4f19\u4f34\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u4f19\u4f34\u89d2\u8272\u7f16\u7801"});
        }
        companyPartner.setCompanyId(CompanyUtils.currentCompanyId());
        companyPartner.setProjectId(ProjectUtils.getProjectId());
        this.companyService.addCompanyAsSupplier(companyPartner);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u7528/\u7981\u6b62\u4f01\u4e1a\u4fe1\u606f")
    @RequestMapping(value={"service/isEnable"})
    @ResponseBody
    public ResponseResult<Integer> isEnable(@ApiParam(value="\u4f01\u4e1aid") @RequestParam(required=true) String id, @ApiParam(value="\u542f\u7528\u4f201,\u7981\u7528\u4f200") Integer isEnable) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("Id\u4e3a\uff0c\u7a7a\u4e0d\u80fd\u7981\u7528\u6216\u542f\u7528", "id_is_blank");
        }
        int result = this.companyService.isEnable(id, isEnable);
        return ResponseResult.success((Object)result);
    }

    @ApiOperation(httpMethod="POST", value="\u7ed9\u4f9b\u5e94\u5546\u6dfb\u52a0\u8d26\u53f7")
    @RequestMapping(value={"service/addSupplierIntoUser"})
    @ResponseBody
    public ResponseResult<String> addSupplierIntoUser(@ApiParam(value="\u4f9b\u5e94\u5546ID") @RequestParam(required=true) String supplierId, @ApiParam(value="\u4f9b\u5e94\u5546\u767b\u9646\u8d26\u53f7\u540d\u79f0") @RequestBody User user) {
        if (StringUtils.isBlank((String)supplierId)) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        if (StringUtils.isBlank((String)user.getLoginName())) {
            throw new CommonException("\u7528\u6237\u8d26\u53f7\u540d\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u7528\u6237\u8d26\u53f7\u540d"});
        }
        if (StringUtils.isBlank((String)user.getPassword())) {
            throw new CommonException("\u7528\u6237\u8d26\u53f7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u7528\u6237\u8d26\u53f7\u5bc6\u7801\u4e0d"});
        }
        if (StringUtils.isBlank((String)user.getMobilePhone())) {
            throw new CommonException("\u7528\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u7528\u6237\u624b\u673a\u53f7"});
        }
        if (StringUtils.isBlank((String)user.getEmail())) {
            throw new CommonException("\u7528\u6237\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u7528\u6237\u90ae\u7bb1"});
        }
        user.setProjectCode(ProjectUtils.getProject().getProjectCode());
        Company company = (Company)this.companyService.queryObjById(supplierId);
        if (company == null) {
            throw new CommonException("\u4f9b\u5e94\u5546 '" + supplierId + "\u4e0d\u5b58\u5728", "do_not_exists", new Object[]{"\u4f9b\u5e94\u5546"});
        }
        this.companyUserRefService.addSupplierIntoUser(company, user);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7ed9\u91c7\u8d2d\u7528\u6237\u6dfb\u52a0\u4f9b\u5e94\u5546\u8d26\u53f7\u5173\u7cfb")
    @RequestMapping(value={"service/addSupplierIntoPurchaser"})
    @ResponseBody
    public ResponseResult<String> addSupplierIntoPurchaser(@ApiParam(value="\u7528\u6237ID") @RequestParam(required=true) String userId, @ApiParam(value="\u4f9b\u5e94\u5546\u5217\u8868") @RequestBody List<Company> companyList) {
        this.companyPurRefService.addSupplierIntoPurchaser(userId, CompanyUtils.currentCompany(), companyList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u7528\u6237\u5bf9\u5e94\u4f9b\u5e94\u5546\u4ee5\u53ca\u91c7\u8d2d\u5546\u7528\u6237")
    @RequestMapping(value={"service/findFriendGroup"})
    @ResponseBody
    public ResponseResult<List<FriendGroup>> findFriendGroup() {
        String userId = SpringSecurityUtils.getLoginUserId();
        List<FriendGroup> supplierUserList = this.companyPurRefService.querySupplyFriendGroup(userId);
        List<FriendGroup> purchaseUserList = this.companyPurRefService.queryPurchaseFriendGroup(CompanyUtils.currentCompanyId());
        ArrayList<FriendGroup> friendGroupList = new ArrayList<FriendGroup>();
        if (CollectionUtils.isNotEmpty(purchaseUserList)) {
            friendGroupList.addAll(purchaseUserList);
        }
        if (CollectionUtils.isNotEmpty(supplierUserList)) {
            friendGroupList.addAll(supplierUserList);
        }
        return ResponseResult.success(friendGroupList);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u4f01\u4e1a\u4e0b\u5168\u90e8\u7684\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findAllSupplyCompany"})
    @ResponseBody
    public ResponseResult<List<Company>> findAllSupplyCompany(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        CompanyExample example = new CompanyExample();
        CompanyExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        List<Company> companyList = this.companyService.queryAllSupplerCompanies(CompanyUtils.currentCompanyId(), example);
        return ResponseResult.success(companyList);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5f53\u524d\u91c7\u8d2d\u5458\uff0c\u7ba1\u7406\u7684\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/findSupCompanyOfCurrentUser"})
    @ResponseBody
    public ResponseResult<List<Company>> findSupCompanyOfCurrentUser(@ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        List<Company> companyList = CompanyUtils.getSupCompanyOfCurrentUser();
        return ResponseResult.success(companyList);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u7684\u516c\u53f8\u7684\u5e10\u53f7", httpMethod="GET")
    @RequestMapping(value={"service/findByCompany"})
    @ResponseBody
    public ResponseResult<PageView<User>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        List<String> userIdList = this.companyUserRefService.queryUserOfCompany(CompanyUtils.currentCompanyId());
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn(userIdList);
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        PageView list = this.userService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)list);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u7684\u516c\u53f8\u7684\u5e10\u53f7\uff08\u73b0\u5728\u7528\u7684\u901a\u7528\u67e5\u8be2\u6761\u4ef6\uff09", httpMethod="POST")
    @RequestMapping(value={"service/findUserByCurrentCompany"})
    @ResponseBody
    public ResponseResult<PageView<User>> findUserByCurrentCompany(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        List<String> userIdList = this.companyUserRefService.queryUserOfCompany(CompanyUtils.currentCompanyId());
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andIdIn(userIdList);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView list = this.userService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)list);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u7684\u516c\u53f8\u7684\u5e10\u53f7", httpMethod="GET")
    @RequestMapping(value={"service/findUserBySupCompany"})
    @ResponseBody
    public ResponseResult<PageView<User>> findUserBySupCompany(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        List<String> userIdList = this.companyUserRefService.queryUserOfCompany(CompanyUtils.currentCompanyId());
        UserExample example = new UserExample();
        example.setPageView(new PageView(pageNo, pageSize));
        example.setOrderByClause("create_time DESC");
        UserExample.Criteria criteria = example.createCriteria();
        criteria.andIdNotIn(userIdList);
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        PageView list = this.userService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)list);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u767b\u5f55\u7684\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findCompanyInformation"})
    @ResponseBody
    public ResponseResult<Company> findCompany(@RequestParam(required=false) String supCompanySrmCode) {
        Company company = null;
        company = StringUtils.isBlank((String)supCompanySrmCode) ? CompanyUtils.currentCompany() : this.companyService.queryCompanyByCode(supCompanySrmCode);
        return ResponseResult.success((Object)company);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"service/updateCompany"})
    @ResponseBody
    public ResponseResult<Map<String, Integer>> updateCompany(@RequestBody Company company) {
        Integer companyStatus = FinishFlagUtils.getFinishFlag(company);
        company.setFinishFlag(companyStatus);
        company.setCompanyFullName(null);
        this.companyService.modifyCompany(ProjectUtils.getProject(), company);
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        map.put("enterpriseBaseInfo", companyStatus);
        return ResponseResult.success(map);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eid\u4fdd\u5b58\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/saveCompanyById"})
    @ResponseBody
    public ResponseResult<String> saveCompanyById(@RequestBody Company company) {
        this.companyService.updateByPrimaryKeySelective(company);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u662f\u5426\u4e0a\u7ebfSRM")
    @RequestMapping(value={"service/isEnableOnline"})
    @ResponseBody
    public ResponseResult<String> isEnableOnline(@RequestParam String companyId) {
        Assert.isNotBlank((String)companyId, (String)"id\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        this.companyService.disableOnlineSrm(companyId);
        return ResponseResult.success();
    }
}

