/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.dao.CompanyPartnerMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value="\u4f9b\u5e94\u5546\u5bfc\u5165")
@Controller
@RequestMapping(value={"importCompany"})
public class CompanyImportController {
    private static Logger log = LoggerFactory.getLogger(CompanyImportController.class);
    @Autowired
    private CompanyService companyService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private UserService userService;
    @Autowired
    private CompanyUserRefService companyUserRefService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private CompanyPartnerMapper companyPartnerMapper;
    @Autowired
    private RoleService roleService;

    @ApiOperation(httpMethod="POST", value="\u4e0b\u8f7d\u4f9b\u5e94\u5546\u5bfc\u5165\u6a21\u677f")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(HttpServletResponse response) {
        FileData excelFile = new FileData();
        try {
            excelFile.setProjectId(ProjectUtils.getProjectId());
            excelFile.setCompanyId(CompanyUtils.currentCompanyId());
            excelFile.setFileName("\u4f9b\u5e94\u5546\u5bfc\u5165\u6a21\u677f.xls");
            excelFile.setFileSuffix("xls");
            excelFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
            excelFile = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), excelFile);
            FileOutputStream outputStream = new FileOutputStream(excelFile.toFile());
            List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, null, (String)"\u4f9b\u5e94\u5546\u5bfc\u5165\u6a21\u677f", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
        return ResponseResult.success((Object)excelFile);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u5bfc\u5165")
    @RequestMapping(value={"service/import"})
    @Transactional
    @ResponseBody
    public ResponseResult<String> importCompany(MultipartHttpServletRequest request) {
        List<Company> companyList = this.getCompanyFromExcel(request);
        this.create(ProjectUtils.getProject(), CompanyUtils.currentCompany(), (User)SpringSecurityUtils.getLoginUser(), companyList);
        return ResponseResult.success();
    }

    private void create(Project project, Company purCompany, User loginUser, List<Company> companyList) {
        this.filterForCreate(companyList);
        for (Company supCompany : companyList) {
            List<Company> list = this.getNewCompanies(purCompany, supCompany);
            this.createUserForCompany(project, list);
            this.createRaForPurCompany(project, list);
        }
    }

    private List<Company> getNewCompanies(Company purCompany, Company supCompany) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andCompanySapCodeEqualTo(supCompany.getCompanySapCode()).andIsEnableEqualTo(Constant.YES_INT);
        List companies = this.companyService.queryAllObjByExample((IExample)companyExample);
        ArrayList<Company> list = new ArrayList<Company>();
        if (CollectionUtils.isNotEmpty((Collection)companies)) {
            Company company = (Company)companies.get(0);
            this.companyService.modifyObj(company);
        } else {
            Company company = new Company();
            BeanUtils.copyProperties((Object)supCompany, (Object)company);
            company.setPassword("edeade8c9f6b8b85f63bbe64f31fe25371809f02cd24278b");
            company.setId(null);
            company.setProjectId(purCompany.getProjectId());
            company.setCreateTime(new Date());
            company.setIsEnable(Constant.YES_INT);
            String nextCompanyCode = this.generateCodeService.getNextCompanyCode();
            company.setCompanyCode(nextCompanyCode);
            this.companyService.addObjByImport(company);
            list.add(company);
        }
        return list;
    }

    private void createRaForPurCompany(Project project, List<Company> list) {
        for (Company company : list) {
            CompanyPartner companyPartner = new CompanyPartner();
            companyPartner.setProjectId(project.getId());
            companyPartner.setCompanyId(project.getCompanyId());
            companyPartner.setPartnerCompanyId(company.getId());
            companyPartner.setPartnerCompanyName(company.getCompanyFullName());
            companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
            companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
            this.companyPartnerMapper.insertSelective(companyPartner);
        }
    }

    private void createUserForCompany(Project project, List<Company> list) {
        for (Company company : list) {
            this.filterForCreateUser(company);
            User user = new User();
            log.info("----" + company.getCompanySapCode());
            user.setLoginName(company.getCompanySapCode());
            user.setNickName(company.getCompanyFullName());
            user.setMobilePhone(company.getMobilephone());
            user.setPassword("123456");
            user.setEmail(company.getEmail());
            user.setCreateTime(new Date());
            user.setUpdateTime(new Date());
            user.setLastLoginTime(new Date());
            user.setIsEnable(Constant.YES_INT);
            if (project != null) {
                user.setProjectCode(project.getProjectCode());
            }
            this.userService.addObj((Serializable)user);
            UserExample userExample = new UserExample();
            userExample.createCriteria().andLoginNameEqualTo(user.getLoginName());
            List users = this.userService.queryAllObjByExample((IExample)userExample);
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                CompanyUserRef ref = new CompanyUserRef();
                ref.setUserId(user.getId());
                ref.setProjectId(company.getProjectId());
                ref.setCompanyId(company.getId());
                if (StringUtils.isEmpty((String)company.getId())) {
                    CompanyExample companyExample = new CompanyExample();
                    companyExample.createCriteria().andCompanySapCodeEqualTo(company.getCompanySapCode()).andIsEnableEqualTo(Constant.YES_INT);
                    List companies = this.companyService.queryAllObjByExample((IExample)companyExample);
                    if (CollectionUtils.isNotEmpty((Collection)companies)) {
                        ref.setCompanyId(((Company)companies.get(0)).getId());
                    }
                }
                ref.setCreateTime(new Date());
                this.companyUserRefService.addObj(ref);
            }
            RoleExample roleExample = new RoleExample();
            roleExample.createCriteria().andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
            List roles = this.roleService.queryAllObjByExample((IExample)roleExample);
            if (!CollectionUtils.isNotEmpty(list)) continue;
            for (Role role : roles) {
                UserRole t = new UserRole();
                t.setUserId(user.getId());
                t.setRoleId(role.getId());
                t.setCreateTime(new Date());
                this.userRoleService.addObj((Serializable)t);
            }
        }
    }

    private void filterForCreateUser(Company company) {
        String mobilePhone;
        String email = company.getEmail();
        if (StringUtils.isNotBlank((String)email)) {
            UserExample userExample = new UserExample();
            userExample.createCriteria().andEmailEqualTo(email);
            List users = this.userService.queryAllObjByExample((IExample)userExample);
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                throw new CommonException(email + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        if (StringUtils.isNotBlank((String)(mobilePhone = company.getMobilephone()))) {
            UserExample userExample = new UserExample();
            userExample.createCriteria().andMobilePhoneEqualTo(mobilePhone);
            List users = this.userService.queryAllObjByExample((IExample)userExample);
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                throw new CommonException(mobilePhone + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
        }
    }

    private void filterForCreate(List<Company> companyList) {
        Assert.isNotEmpty(companyList, (String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (Company company : companyList) {
            Assert.isNotBlank((String)company.getCompanySapCode(), (String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotBlank((String)company.getCompanyName(), (String)"\u4f9b\u5e94\u5546\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotBlank((String)company.getCompanyFullName(), (String)"\u4f9b\u5e94\u5546\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotBlank((String)company.getMobilephone(), (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.isNotBlank((String)company.getEmail(), (String)"\u7535\u5b50\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public static List<TitleAndModelKey> createExcelHeader() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u540d\u79f0", (String)"companyFullName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u4ee3\u7801", (String)"companySapCode", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7ec4\u7ec7", (String)"purchasingGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b80\u79f0", (String)"companyName", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8857\u9053/\u95e8\u724c\u53f7", (String)"address"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fd\u5bb6", (String)"country"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5730\u533a", (String)"city"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u624b\u673a\u53f7\u7801", (String)"mobilephone", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fa\u5b9a\u7535\u8bdd", (String)"telephone"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f20\u771f", (String)"fax"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"E-mail", (String)"email", (boolean)true));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ec4\u4ee3\u7801", (String)"groupCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ee3\u8868\u540d\u79f0", (String)"delegateType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"businessType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u4e1a\u7c7b\u578b", (String)"industrialType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u884c\u4e1a\u7c7b\u578b\u7f16\u7801", (String)"industryCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u884c\u4e1a\u7c7b\u578b\u63cf\u8ff0", (String)"industryDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5916\u90e8\u5236\u9020\u5546", (String)"externalManufacturer"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7edf\u9a6d\u79d1\u76ee", (String)"reconciliationAccountCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ed8\u6b3e\u6761\u4ef6", (String)"payConditionsCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u8d27\u5e01", (String)"orderCurren"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fd\u9645\u8d38\u6613\u6761\u4ef6", (String)"internationalTradeCondition"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9500\u552e\u5458", (String)"salesman"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9500\u552e\u5458\u8054\u7cfb\u53f7\u7801", (String)"salesmanPhone"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u57fa\u4e8e\u6536\u8d27\u7684\u53d1\u7968\u9a8c\u8bc1", (String)"invoiceVerify"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u81ea\u52a8\u5efa\u7acb\u91c7\u8d2d\u8ba2\u5355", (String)"automaticPurchaseOrder"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u5458", (String)"purchasingStaff"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u5212\u4ea4\u4ed8\u65f6\u95f4", (String)"plannedDeliveryTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5c5e\u6027", (String)"supplyProperties"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7a0e\u7387", (String)"taxRate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7a0e\u7801", (String)"taxCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u68c0\u7d22\u9879", (String)"companyRetrieve"));
        return titleAndModelKeys;
    }

    public List<Company> getCompanyFromExcel(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
        ArrayList<Company> list = new ArrayList();
        try {
            list = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, Company.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return list;
    }

    public MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".xls")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301xls");
        }
        return file;
    }
}

