/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u89d2\u8272\u7ba1\u7406")
@Controller(value="companyRoleControler")
@RequestMapping(value={"roleForCompany"})
public class RoleController {
    @Autowired
    private RoleService roleService;

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/addRole"})
    @ResponseBody
    public ResponseResult<String> addRole(@RequestBody Role role) {
        role.setId(null);
        role.setProjectId(ProjectUtils.getProjectId());
        role.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        role.setCompanyId(CompanyUtils.currentCompanyId());
        this.roleService.addObj((Serializable)role);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u89d2\u8272\uff0c\u5e76\u6807\u8bb0\u662f\u5426\u5df2\u6388\u6743", httpMethod="GET")
    @RequestMapping(value={"service/queryAllRoleWithAuthTag"})
    @ResponseBody
    public ResponseResult<List<Role>> queryAllRoleWithAuthTag(@ApiParam(value="\u7528\u6237id") String userId) {
        if (StringUtils.isBlank((String)userId)) {
            throw new CommonException("id\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c", "id_is_blank");
        }
        List roleIds = SpringSecurityUtils.getLoginUserRoleIdList();
        RoleExample roleExample = new RoleExample();
        RoleExample.Criteria criteria = roleExample.createCriteria();
        if (!SpringSecurityUtils.isManagerLoginUser()) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIdIn(roleIds);
            RoleExample.Criteria or = roleExample.or();
            or.andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        }
        List allRoles = this.roleService.queryAllObjByExample((IExample)roleExample);
        List rolesOfUser = this.roleService.queryUserOwnRoles(userId);
        if (CollectionUtils.isEmpty((Collection)rolesOfUser)) {
            return ResponseResult.success((Object)allRoles);
        }
        ArrayList<String> roleIdsOfUser = new ArrayList<String>();
        for (Role role : rolesOfUser) {
            roleIdsOfUser.add(role.getId());
        }
        for (Role role : allRoles) {
            role.setAuthorized(roleIdsOfUser.contains(role.getId()));
        }
        return ResponseResult.success((Object)allRoles);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u7684\u89d2\u8272", httpMethod="POST")
    @RequestMapping(value={"service/queryAllRoleByPage"})
    @ResponseBody
    public ResponseResult<PageView<Role>> queryAllRoleByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        List roleIds = SpringSecurityUtils.getLoginUserRoleIdList();
        RoleExample roleExample = new RoleExample();
        roleExample.setPageView(new PageView(pageNo, pageSize));
        RoleExample.Criteria criteria = roleExample.createCriteria();
        if (!SpringSecurityUtils.isManagerLoginUser()) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIdIn(roleIds);
            RoleExample.Criteria or = roleExample.or();
            or.andProjectIdEqualTo(ProjectUtils.getProjectId()).andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        }
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion((Object)criteria, queryParams);
        }
        roleExample.setOrderByClause("CREATE_TIME DESC");
        PageView pageData = this.roleService.queryObjByPage((IExample)roleExample);
        return ResponseResult.success((Object)pageData);
    }
}

