/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.template.service.impl;

import com.els.base.contract.template.dao.ContractTemplateMapper;
import com.els.base.contract.template.emum.AuditStatus;
import com.els.base.contract.template.entity.ContractTemplate;
import com.els.base.contract.template.entity.ContractTemplateExample;
import com.els.base.contract.template.service.ContractTemplateService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service(value="defaultContractTemplateService")
public class ContractTemplateServiceImpl
implements ContractTemplateService,
ITaskListener {
    @Resource
    protected ContractTemplateMapper contractTemplateMapper;
    @Resource
    protected WorkFlowService workFlowService;

    @CacheEvict(value={"contractTemplate"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        if (event == null) {
            return;
        }
        String businessId = event.getBusinessId();
        if (org.apache.commons.lang.StringUtils.isBlank((String)businessId)) {
            return;
        }
        ContractTemplate contractTemplate = this.contractTemplateMapper.selectByPrimaryKey(businessId);
        String assignee = org.apache.commons.lang.StringUtils.defaultIfBlank((String)event.getAssignee(), (String)"");
        String fullMessage = org.apache.commons.lang.StringUtils.defaultIfBlank((String)event.getApproveDesc(), (String)"");
        String result = "\u5ba1\u6279\u4eba\uff1a" + assignee + "\uff0c\u5ba1\u6279\u610f\u89c1\uff1a" + fullMessage + " ; ";
        if (event.isFinished() && event.isPass()) {
            contractTemplate.setAuditStatus(AuditStatus.AUDITED.getCode());
            contractTemplate.setApproveResult(result);
            this.contractTemplateMapper.updateByPrimaryKeySelective(contractTemplate);
        } else if (event.isFinished() && !event.isPass()) {
            contractTemplate.setAuditStatus(AuditStatus.REFUSED.getCode());
            this.contractTemplateMapper.updateByPrimaryKeySelective(contractTemplate);
        }
    }

    @CacheEvict(value={"contractTemplate"}, allEntries=true)
    public void addObj(ContractTemplate t) {
        this.contractTemplateMapper.insertSelective(t);
    }

    @CacheEvict(value={"contractTemplate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.contractTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"contractTemplate"}, allEntries=true)
    public void modifyObj(ContractTemplate t) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.contractTemplateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"contractTemplate"}, keyGenerator="redisKeyGenerator")
    public ContractTemplate queryObjById(String id) {
        return this.contractTemplateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"contractTemplate"}, keyGenerator="redisKeyGenerator")
    public List<ContractTemplate> queryAllObjByExample(ContractTemplateExample example) {
        return this.contractTemplateMapper.selectByExample(example);
    }

    @Cacheable(value={"contractTemplate"}, keyGenerator="redisKeyGenerator")
    public PageView<ContractTemplate> queryObjByPage(ContractTemplateExample example) {
        PageView<ContractTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.contractTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    public void deleteByExample(ContractTemplateExample example) {
    }

    public void addAll(List<ContractTemplate> list) {
    }

    @Override
    @Transactional
    @CacheEvict(value={"contractTemplate"}, allEntries=true)
    public void approve(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6838\uff01");
        ContractTemplateExample example = new ContractTemplateExample();
        example.createCriteria().andIdIn((List)ids).andAuditStatusEqualTo(AuditStatus.UNAUDITED.getCode());
        int count = this.contractTemplateMapper.countByExample(example);
        if (count != ids.size()) {
            throw new CommonException("\u53ea\u6709\u5904\u4e8e\u672a\u5ba1\u6279\u7684\u8bb0\u5f55\u624d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u68c0\u67e5");
        }
        List<ContractTemplate> contractTemplates = this.contractTemplateMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(contractTemplates)) {
            return;
        }
        for (ContractTemplate contractTemplate : contractTemplates) {
            ProcessStartVO vo = ProcessStartVO.newInstance((String)"ct", (String)contractTemplate.getTemplateNo(), (String)contractTemplate.getId(), (String)("template?id=" + contractTemplate.getId()));
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            contractTemplate.setAuditStatus(AuditStatus.TOAUDIT.getCode());
            this.contractTemplateMapper.updateByPrimaryKeySelective(contractTemplate);
        }
    }

    @Override
    @Transactional
    @Cacheable(value={"contractTemplate"}, keyGenerator="redisKeyGenerator")
    public void modifyById(String id) {
        this.contractTemplateMapper.modifyById(id);
    }

    @Override
    @CacheEvict(value={"contractTemplate"}, allEntries=true)
    public void addAttachment(ContractTemplate contractTemplate) {
        String id = contractTemplate.getId();
        if (StringUtils.isEmpty((Object)id)) {
            throw new CommonException("\u5408\u540c\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contractTemplateMapper.updateByPrimaryKeySelective(contractTemplate);
    }
}

