/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.manage.service.impl;

import com.els.base.contract.manage.dao.ContractManageMapper;
import com.els.base.contract.manage.emum.ContractStatus;
import com.els.base.contract.manage.entity.ContractManage;
import com.els.base.contract.manage.entity.ContractManageExample;
import com.els.base.contract.manage.service.ContractManageService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="defaultContractManageService")
public class ContractManageServiceImpl
implements ContractManageService,
ITaskListener {
    @Resource
    protected ContractManageMapper contractManageMapper;
    @Resource
    protected WorkFlowService workFlowService;

    @CacheEvict(value={"pricingBill"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        if (event == null) {
            return;
        }
        String businessId = event.getBusinessId();
        if (org.apache.commons.lang.StringUtils.isBlank((String)businessId)) {
            return;
        }
        ContractManage contractManage = this.contractManageMapper.selectByPrimaryKey(businessId);
        String assignee = org.apache.commons.lang.StringUtils.defaultIfBlank((String)event.getAssignee(), (String)"");
        String fullMessage = org.apache.commons.lang.StringUtils.defaultIfBlank((String)event.getApproveDesc(), (String)"");
        String result = "\u5ba1\u6279\u4eba\uff1a" + assignee + "\uff0c\u5ba1\u6279\u610f\u89c1\uff1a" + fullMessage + " ; ";
        if (event.isFinished() && event.isPass()) {
            contractManage.setContractStatus(ContractStatus.AUDITED.getCode());
            contractManage.setApproveResult(result);
            this.contractManageMapper.updateByPrimaryKeySelective(contractManage);
        } else if (event.isFinished() && !event.isPass()) {
            contractManage.setContractStatus(ContractStatus.APPROVAL_REFUSE.getCode());
            this.contractManageMapper.updateByPrimaryKeySelective(contractManage);
        }
    }

    @CacheEvict(value={"contractManage"}, allEntries=true)
    public void addObj(ContractManage t) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)t.getTemplateNo())) {
            throw new NullPointerException("\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contractManageMapper.insertSelective(t);
    }

    @CacheEvict(value={"contractManage"}, allEntries=true)
    public void deleteObjById(String id) {
        this.contractManageMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"contractManage"}, allEntries=true)
    public void modifyObj(ContractManage t) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.contractManageMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"contractManage"}, keyGenerator="redisKeyGenerator")
    public ContractManage queryObjById(String id) {
        return this.contractManageMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"contractManage"}, keyGenerator="redisKeyGenerator")
    public List<ContractManage> queryAllObjByExample(ContractManageExample example) {
        return this.contractManageMapper.selectByExample(example);
    }

    public PageView<ContractManage> queryObjByPage(ContractManageExample example) {
        PageView<ContractManage> pageView = example.getPageView();
        pageView.setQueryResult(this.contractManageMapper.selectByExampleByPage(example));
        return pageView;
    }

    public void deleteByExample(ContractManageExample example) {
    }

    public void addAll(List<ContractManage> list) {
    }

    @Override
    @Cacheable(value={"contractManage"}, keyGenerator="redisKeyGenerator")
    public void modifyById(String id) {
        this.contractManageMapper.modifyById(id);
    }

    @Override
    @CacheEvict(value={"contractManage"}, allEntries=true)
    public void addAttachment(ContractManage contractManage) {
        String id = contractManage.getId();
        if (StringUtils.isEmpty((Object)id)) {
            throw new CommonException("\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contractManageMapper.updateByPrimaryKeySelective(contractManage);
    }

    @Override
    @CacheEvict(value={"contractManage"}, allEntries=true)
    public void approve(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6838\uff01");
        ContractManageExample contractManageExample = new ContractManageExample();
        contractManageExample.createCriteria().andIdIn((List)ids);
        List<ContractManage> contractManages = this.contractManageMapper.selectByExample(contractManageExample);
        if (CollectionUtils.isEmpty(contractManages)) {
            return;
        }
        for (ContractManage contractManage : contractManages) {
            ProcessStartVO vo = ProcessStartVO.newInstance((String)"ht", (String)contractManage.getContractNo(), (String)contractManage.getId(), (String)("contractManage?id=" + contractManage.getId()));
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            contractManage.setContractStatus(ContractStatus.TOAUDIT.getCode());
            this.contractManageMapper.updateByPrimaryKeySelective(contractManage);
        }
    }
}

