/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.manage.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.contract.manage.emum.ContractStatus;
import com.els.base.contract.manage.entity.ContractManage;
import com.els.base.contract.manage.entity.ContractManageExample;
import com.els.base.contract.manage.service.ContractManageService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4f9b\u5e94\u5546\u5408\u540c\u7ba1\u7406"})
@Controller
@RequestMapping(value={"supContractManage"})
public class SupContractManageController {
    @Resource
    protected ContractManageService contractManageService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2T_CONTRACT_MANAGE")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 ContractManage", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ContractManage>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ContractManageExample example = new ContractManageExample();
        example.setPageView((PageView<ContractManage>)new PageView(pageNo, pageSize));
        ContractManageExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andIssendEqualTo(1);
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.contractManageService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4e3b\u952eid\u67e5\u8be2\u8be6\u60c5\u5355\u4e2a")
    @RequestMapping(value={"service/queryById"})
    @ResponseBody
    public ResponseResult<ContractManage> queryTemplateById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u67e5\u8be2id\u4e0d\u80fd\u4e3a\u7a7a");
        ContractManage contractManage = (ContractManage)this.contractManageService.queryObjById(id);
        return ResponseResult.success((Object)contractManage);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u786e\u8ba4")
    @RequestMapping(value={"service/supconfirm"})
    @ResponseBody
    public ResponseResult<String> toSupConfirm(@RequestBody ContractManage contractManage) {
        if (StringUtils.isBlank((String)contractManage.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (contractManage.getContractStatus() != 2) {
            throw new CommonException("\u53ea\u6709\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4\u72b6\u6001\u624d\u53ef\u4ee5\u786e\u8ba4");
        }
        contractManage.setContractStatus(ContractStatus.SUPPLIER_CONFIRMED.getCode());
        this.contractManageService.modifyObj(contractManage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u62d2\u7edd")
    @RequestMapping(value={"service/suprefuse"})
    @ResponseBody
    public ResponseResult<String> supRefused(@RequestBody ContractManage contractManage) {
        if (StringUtils.isBlank((String)contractManage.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (contractManage.getContractStatus() != 2) {
            throw new CommonException("\u53ea\u6709\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4\u72b6\u6001\u624d\u53ef\u4ee5\u62d2\u7edd");
        }
        contractManage.setContractStatus(ContractStatus.SUPPLIER_REFUSED.getCode());
        this.contractManageService.modifyObj(contractManage);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/attachment"})
    @ResponseBody
    public ResponseResult<String> attachment(@RequestBody ContractManage contractManage) {
        if (StringUtils.isBlank((String)contractManage.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.contractManageService.addAttachment(contractManage);
        return ResponseResult.success();
    }
}

