
-- ----------------------------
-- 阶段付款表
-- ----------------------------
-- DROP TABLE "T_CONTRACT_STAGE_PAYMENT";
CREATE TABLE "T_CONTRACT_STAGE_PAYMENT" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "CONTRACT_NUM" VARCHAR2(32 BYTE) ,
  "PAYMENT_STAGE" VARCHAR2(255 BYTE) ,
  "PAYMENT_DESCRIPTION" VARCHAR2(255 BYTE) ,
  "PAYMENT_PROPORTION" NUMBER(3) ,
  "PLAN_PAYMENT_TIME" DATE ,
  "PLAN_PAYMENT_AMOUNT" NUMBER(15,2) ,
  "INVOICE_TIME" DATE ,
  "INVOICE_AMOUNT" NUMBER(15,2) ,
  "PAYMENT_TIME" DATE ,
  "CONTRACT_ID" VARCHAR2(255 BYTE) ,
  "REMART" VARCHAR2(255 BYTE) ,
  "WARNING_DAYS" NUMBER(7) 
);

COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."ID" IS 'ID';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."PUR_COMPANY_ID" IS '公司id';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."CONTRACT_NUM" IS '合同编号';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."PAYMENT_STAGE" IS '付款阶段';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."PAYMENT_DESCRIPTION" IS '付款描述';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."PAYMENT_PROPORTION" IS '付款比例';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."PLAN_PAYMENT_TIME" IS '计划付款时间';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."PLAN_PAYMENT_AMOUNT" IS '计划付款金额';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."INVOICE_TIME" IS '开发票时间';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."INVOICE_AMOUNT" IS '开发票金额';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."PAYMENT_TIME" IS '实际付款时间';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."CONTRACT_ID" IS '合同台账ID';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."REMART" IS '备注';
COMMENT ON COLUMN "T_CONTRACT_STAGE_PAYMENT"."WARNING_DAYS" IS '提前提醒天数';
COMMENT ON TABLE "T_CONTRACT_STAGE_PAYMENT" IS '阶段付款表';


ALTER TABLE "T_CONTRACT_STAGE_PAYMENT" ADD  PRIMARY KEY ("ID");
