/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.ledger.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.contract.ledger.entity.ContractFile;
import com.els.base.contract.ledger.entity.StageDivision;
import com.els.base.contract.ledger.entity.StagePayment;
import com.els.base.contract.ledger.entity.StandingBook;
import com.els.base.contract.ledger.service.ContractFileService;
import com.els.base.contract.ledger.service.StageDivisionService;
import com.els.base.contract.ledger.service.StagePaymentService;
import com.els.base.contract.ledger.service.StandingBookService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.transaction.annotation.Transactional;

public class StandingBookAddCmd
extends BaseCommand<String> {
    private StandingBook standingBook;

    public StandingBookAddCmd(StandingBook standingBook) {
        this.standingBook = standingBook;
    }

    @Transactional
    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.standingBook);
        this.process(this.standingBook);
        return this.standingBook.getId();
    }

    private void process(StandingBook standingBook) {
        StandingBookService standingBookService = (StandingBookService)SpringContextHolder.getOneBean(StandingBookService.class);
        StagePaymentService stagePaymentService = (StagePaymentService)SpringContextHolder.getOneBean(StagePaymentService.class);
        StageDivisionService stageDivisionService = (StageDivisionService)SpringContextHolder.getOneBean(StageDivisionService.class);
        ContractFileService contractFileService = (ContractFileService)SpringContextHolder.getOneBean(ContractFileService.class);
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String standingBookCode = generateCodeService.getNextCode("STANDING_BOOK");
        standingBook.setContractNo(standingBookCode);
        standingBook.setCreateTime(new Date());
        standingBookService.addObj(standingBook);
        String id = standingBook.getId();
        List<ContractFile> contractFileList = standingBook.getContractFileList();
        if (CollectionUtils.isNotEmpty(contractFileList)) {
            for (ContractFile contractFile : contractFileList) {
                contractFile.setContractNum(standingBookCode);
                contractFile.setContractId(id);
            }
            contractFileService.addAll(contractFileList);
        }
        List<StageDivision> stageDivisionList = standingBook.getDivisions();
        for (StageDivision stageDivision : stageDivisionList) {
            stageDivision.setContractNum(standingBookCode);
            stageDivision.setContractId(id);
        }
        stageDivisionService.addAll(stageDivisionList);
        List<StagePayment> list = standingBook.getPayments();
        for (StagePayment stagePayment : list) {
            stagePayment.setContractNum(standingBookCode);
            stagePayment.setContractId(id);
        }
        stagePaymentService.addAll(list);
    }

    private void check(StandingBook standingBook) {
        Assert.isNotNull((Object)standingBook, (String)"\u53f0\u8d26\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<StageDivision> stageDivisionList = standingBook.getDivisions();
        Assert.isNotEmpty(stageDivisionList, (String)"\u9636\u6bb5\u5212\u5206\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        List<StagePayment> stagePaymentList = standingBook.getPayments();
        Assert.isNotEmpty(stagePaymentList, (String)"\u9636\u6bb5\u4ed8\u6b3e\u8868\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

