/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.ledger.service.impl;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.contract.ledger.dao.StageDivisionMapper;
import com.els.base.contract.ledger.entity.StageDivision;
import com.els.base.contract.ledger.entity.StageDivisionExample;
import com.els.base.contract.ledger.entity.StandingBook;
import com.els.base.contract.ledger.service.StageDivisionService;
import com.els.base.contract.ledger.service.StandingBookService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultStageDivisionService")
public class StageDivisionServiceImpl
implements StageDivisionService {
    @Resource
    protected StageDivisionMapper stageDivisionMapper;
    @Resource
    protected StandingBookService standingBookService;

    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void addObj(StageDivision t) {
        this.stageDivisionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void addAll(List<StageDivision> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.stageDivisionMapper.insertBatch(list);
    }

    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void deleteObjById(String id) {
        this.stageDivisionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void deleteByExample(StageDivisionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.stageDivisionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void modifyObj(StageDivision t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.stageDivisionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"stageDivision"}, keyGenerator="redisKeyGenerator")
    public StageDivision queryObjById(String id) {
        return this.stageDivisionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"stageDivision"}, keyGenerator="redisKeyGenerator")
    public List<StageDivision> queryAllObjByExample(StageDivisionExample example) {
        return this.stageDivisionMapper.selectByExample(example);
    }

    @Cacheable(value={"stageDivision"}, keyGenerator="redisKeyGenerator")
    public PageView<StageDivision> queryObjByPage(StageDivisionExample example) {
        PageView<StageDivision> pageView = example.getPageView();
        pageView.setQueryResult(this.stageDivisionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void contractWarn() {
        List<StageDivision> stageDivisions = this.stageDivisionMapper.stageDivisionWarn();
        if (null != stageDivisions && stageDivisions.size() > 0) {
            for (int i = 0; i < stageDivisions.size(); ++i) {
                StageDivision stageDivision = stageDivisions.get(i);
                String contractNum = stageDivision.getContractNum();
                String stageName = stageDivision.getStageName();
                String message = "\u60a8\u7684" + contractNum + "\u5408\u540c" + stageName + "\u9636\u6bb5\u5df2\u7ecf\u5feb\u8981\u5931\u6548\uff0c\u8bf7\u786e\u8ba4";
                this.sendEmail(message);
                this.sendWeixin(message);
                this.sendMessageStageDivisionWarn(stageDivision);
            }
        }
    }

    private void sendMessageStageDivisionWarn(StageDivision stageDivision) {
        StandingBook standingBook = (StandingBook)this.standingBookService.queryObjById(stageDivision.getContractId());
        String createUserId = standingBook.getCreateUserId();
        Message message = Message.init((Object)stageDivision).setCompanyCode(CompanyUtils.currentCompany().getCompanyCode()).setBusinessTypeCode("STAGE_DIVISION_WARN").setMsgLevel(MessageLevelEnum.HIGH).addReceiverId(createUserId);
        MessageSendUtils.sendMessage((Message)message);
    }

    private void sendEmail(String message) {
        System.out.println(message);
    }

    private void sendWeixin(String message) {
        System.out.println(message);
    }
}

