/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.ledger.service.impl;

import com.els.base.contract.ledger.dao.StandingBookMapper;
import com.els.base.contract.ledger.entity.StandingBook;
import com.els.base.contract.ledger.entity.StandingBookExample;
import com.els.base.contract.ledger.service.StandingBookService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultStandingBookService")
public class StandingBookServiceImpl
implements StandingBookService {
    @Resource
    protected StandingBookMapper standingBookMapper;

    @CacheEvict(value={"standingBook"}, allEntries=true)
    public void addObj(StandingBook t) {
        this.standingBookMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"standingBook"}, allEntries=true)
    public void addAll(List<StandingBook> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.standingBookMapper.insertBatch(list);
    }

    @CacheEvict(value={"standingBook"}, allEntries=true)
    public void deleteObjById(String id) {
        this.standingBookMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"standingBook"}, allEntries=true)
    public void deleteByExample(StandingBookExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.standingBookMapper.deleteByExample(example);
    }

    @CacheEvict(value={"standingBook"}, allEntries=true)
    public void modifyObj(StandingBook t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.standingBookMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"standingBook"}, keyGenerator="redisKeyGenerator")
    public StandingBook queryObjById(String id) {
        return this.standingBookMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"standingBook"}, keyGenerator="redisKeyGenerator")
    public List<StandingBook> queryAllObjByExample(StandingBookExample example) {
        return this.standingBookMapper.selectByExample(example);
    }

    @Cacheable(value={"standingBook"}, keyGenerator="redisKeyGenerator")
    public PageView<StandingBook> queryObjByPage(StandingBookExample example) {
        PageView<StandingBook> pageView = example.getPageView();
        pageView.setQueryResult(this.standingBookMapper.selectByExampleByPage(example));
        return pageView;
    }
}

