/*
 * Decompiled with CFR 0.152.
 */
package com.els.kangni.contract.manage.utils;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.els.kangni.contract.manage.entity.ContractManage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractPrintUtils {
    private static Logger logger = LoggerFactory.getLogger(ContractPrintUtils.class);

    public static FileData generatePdf(String contractContent, String projectId, String companyId) {
        String filename = null;
        FileData pdfFile = null;
        filename = "\u5408\u540c\u6b63\u6587" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
        try {
            pdfFile = ContractPrintUtils.createEmptyPDF(projectId, companyId, filename);
            HtmlToPdfUtils.generatePdf((String)contractContent, (File)pdfFile.toFile(), (String)"A4", (boolean)true, (String)filename);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u51faPDF\u5f02\u5e38");
        }
        return pdfFile;
    }

    public static FileData generatePdf(ContractManage contractManage) {
        HashMap<String, ContractManage> params = new HashMap<String, ContractManage>();
        params.put("ContractManage", contractManage);
        String filename = null;
        FileData pdfFile = null;
        String html = null;
        html = BeetlTemplateUtils.renderFromFile((String)"ContractManagerContent.html", params);
        logger.info("PDF---HTML\u5185\u5bb9" + html);
        logger.info(html);
        filename = "\u5408\u540c\u6b63\u6587" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
        try {
            logger.info("PDF---HTML\u5185\u5bb9" + html);
            pdfFile = ContractPrintUtils.createEmptyPDF(CompanyUtils.currentCompany().getProjectId(), CompanyUtils.currentCompanyId(), filename);
            HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (String)"A4", (boolean)true, (String)filename);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u51faPDF\u5f02\u5e38");
        }
        return pdfFile;
    }

    public static FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }
}

