/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.ledger.service.impl;

import com.els.base.contract.ledger.dao.ContractFileMapper;
import com.els.base.contract.ledger.entity.ContractFile;
import com.els.base.contract.ledger.entity.ContractFileExample;
import com.els.base.contract.ledger.service.ContractFileService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultContractFileService")
public class ContractFileServiceImpl
implements ContractFileService {
    @Resource
    protected ContractFileMapper contractFileMapper;

    @CacheEvict(value={"contractFile"}, allEntries=true)
    public void addObj(ContractFile t) {
        this.contractFileMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"contractFile"}, allEntries=true)
    public void addAll(List<ContractFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.contractFileMapper.insertBatch(list);
    }

    @CacheEvict(value={"contractFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.contractFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"contractFile"}, allEntries=true)
    public void deleteByExample(ContractFileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.contractFileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"contractFile"}, allEntries=true)
    public void modifyObj(ContractFile t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.contractFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"contractFile"}, keyGenerator="redisKeyGenerator")
    public ContractFile queryObjById(String id) {
        return this.contractFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"contractFile"}, keyGenerator="redisKeyGenerator")
    public List<ContractFile> queryAllObjByExample(ContractFileExample example) {
        return this.contractFileMapper.selectByExample(example);
    }

    @Cacheable(value={"contractFile"}, keyGenerator="redisKeyGenerator")
    public PageView<ContractFile> queryObjByPage(ContractFileExample example) {
        PageView<ContractFile> pageView = example.getPageView();
        pageView.setQueryResult(this.contractFileMapper.selectByExampleByPage(example));
        return pageView;
    }
}

