/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.ledger.web.controller;

import com.els.base.contract.ledger.entity.ContractFile;
import com.els.base.contract.ledger.entity.ContractFileExample;
import com.els.base.contract.ledger.service.ContractFileService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5408\u540c\u9644\u4ef6\u8868"})
@Controller
@RequestMapping(value={"contractFile"})
public class ContractFileController {
    @Resource
    protected ContractFileService contractFileService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5408\u540c\u9644\u4ef6\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ContractFile contractFile) {
        this.contractFileService.addObj(contractFile);
        return ResponseResult.success((Object)contractFile.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5408\u540c\u9644\u4ef6\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ContractFile contractFile) {
        Assert.isNotBlank((String)contractFile.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.contractFileService.modifyObj(contractFile);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5408\u540c\u9644\u4ef6\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        ContractFileExample example = new ContractFileExample();
        example.createCriteria().andIdIn((List)ids);
        this.contractFileService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5408\u540c\u9644\u4ef6\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 ContractFile", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<ContractFile>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ContractFileExample example = new ContractFileExample();
        example.setPageView((PageView<ContractFile>)new PageView(pageNo, pageSize));
        ContractFileExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.contractFileService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5408\u540c\u9644\u4ef6\u8868(\u4e0d\u5206\u9875)")
    @RequestMapping(value={"service/find", "service/findAll"})
    @ResponseBody
    public ResponseResult<List<ContractFile>> find(@RequestBody(required=false) QueryParamWapper wapper) {
        ContractFileExample example = new ContractFileExample();
        ContractFileExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List contractFileList = this.contractFileService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)contractFileList);
    }
}

