-- ----------------------------
-- 合同管理
-- ----------------------------
-- DROP TABLE "T_CONTRACT_MANAGE";
-- CREATE TABLE "T_CONTRACT_MANAGE"
-- (
--     "ID"                   VARCHAR2(32 BYTE) NOT NULL,
--     "CONTRACT_NO"          VARCHAR2(32 BYTE),
--     "CONTRACT_DESCRIPTION" VARCHAR2(255 BYTE),
--     "CONTRACT_TYPE"        VARCHAR2(255 BYTE),
--     "CONTRACT_NAME"        VARCHAR2(255 BYTE),
--     "VERSION"              VARCHAR2(32 BYTE),
--     "TEMPLATE_NO"          VARCHAR2(32 BYTE),
--     "TEMPLATE_TYPE"        VARCHAR2(32 BYTE),
--     "TEMPLATE_VERSION"     VARCHAR2(32 BYTE),
--     "ISSEND"               NUMBER(11),
--     "APPROVE_RESULT"       VARCHAR2(255 BYTE),
--     "CONTRACT_STATUS"      NUMBER(11),
--     "SIGN_DATE"            DATE,
--     "EFFECTIVE_DATE"       DATE,
--     "EXPIRATION_DATE"      DATE,
--     "SIGN_PLACE"           VARCHAR2(255 BYTE),
--     "PUR_COMPANY_ID"       VARCHAR2(32 BYTE),
--     "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE),
--     "PUR_COMPANY_SAP_COD"  VARCHAR2(255 BYTE),
--     "PUR_COMPANY_NAME"     VARCHAR2(255 BYTE),
--     "PUR_GROUP"            VARCHAR2(255 BYTE),
--     "PUR_HEAD"             VARCHAR2(255 BYTE),
--     "PUR_MARK"             VARCHAR2(255 BYTE),
--     "BUSINESS_GROUP"       VARCHAR2(255 BYTE),
--     "REMIND_DAYS"          NUMBER(11),
--     "SUP_COMPANY_ID"       VARCHAR2(32 BYTE),
--     "SUP_COMPANY_NAME"     VARCHAR2(255 BYTE),
--     "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE),
--     "SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE),
--     "SUP_HEAD"             VARCHAR2(255 BYTE),
--     "SUP_MARK"             VARCHAR2(255 BYTE),
--     "TYPE"                 NUMBER(11),
--     "CREATE_USER_NAME"     VARCHAR2(255 BYTE),
--     "CREATE_USER_TIME"     DATE,
--     "UPDATE_USER_NAME"     VARCHAR2(255 BYTE),
--     "UPDATE_USER_TIME"     DATE,
--     "SUPATTACHMENT"        VARCHAR2(3500 BYTE),
--     "FILE_TYPE"            VARCHAR2(255 BYTE),
--     "IS_ENABLE"            NUMBER(11),
--     "CONTRACT_CONTENT"     CLOB,
--     "ATTACHMENT"           CLOB
-- );
--
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."ID" IS '主键ID';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."CONTRACT_NO" IS '合同编号';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."CONTRACT_DESCRIPTION" IS '合同描述';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."CONTRACT_TYPE" IS '合同类型';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."CONTRACT_NAME" IS '合同名称';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."VERSION" IS '版本';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."TEMPLATE_NO" IS '模板编号';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."TEMPLATE_TYPE" IS '模板类型';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."ISSEND" IS '是否发送给供应方（1=发送，0=未发送)';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."APPROVE_RESULT" IS '送审结果';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."CONTRACT_STATUS" IS '合同新建=1，供应商待确认=2，供应商已确认=3，供应商拒绝=4，审批中=5，审批通过=6，审批拒绝=7，签署合同=8，作废=9，归档=10';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."SIGN_DATE" IS '签订日期';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."EFFECTIVE_DATE" IS '生效日期';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."EXPIRATION_DATE" IS '到期日期';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."SIGN_PLACE" IS '签订地点';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."PUR_COMPANY_ID" IS '采购方ID';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."PUR_COMPANY_SAP_COD" IS '采购商公司SAP编码';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."PUR_COMPANY_NAME" IS '采购组织';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."PUR_GROUP" IS '采购组';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."PUR_HEAD" IS '采购负责人';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."PUR_MARK" IS '采购方备注';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."BUSINESS_GROUP" IS '业务组';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."REMIND_DAYS" IS '提醒天数';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."SUP_COMPANY_ID" IS '供应方ID';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."SUP_COMPANY_NAME" IS '供应方name';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."SUP_COMPANY_SAP_CODE" IS '供应商公司SAP编码';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."SUP_HEAD" IS '供应方负责人';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."SUP_MARK" IS '供应方备注';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."TYPE" IS '类型（采购方=1，供应方=0）';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."CREATE_USER_NAME" IS '创建人';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."CREATE_USER_TIME" IS '创建时间';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."UPDATE_USER_NAME" IS '更新人';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."UPDATE_USER_TIME" IS '更新时间';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."FILE_TYPE" IS '文件类型';
-- COMMENT ON COLUMN "T_CONTRACT_MANAGE"."IS_ENABLE" IS '软删除（可用=1，不可用=0）';
--
-- ALTER TABLE "T_CONTRACT_MANAGE"
--     ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 合同模板
-- ----------------------------
-- DROP TABLE "T_CONTRACT_TEMPLATE";
-- CREATE TABLE "T_CONTRACT_TEMPLATE"
-- (
--     "ID"                   VARCHAR2(32 BYTE) NOT NULL,
--     "PUR_COMPANY_ID"       VARCHAR2(32 BYTE),
--     "PUR_COMPANY_NAME"     VARCHAR2(255 BYTE),
--     "PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE),
--     "PUR_COMPANY_SAP_CODE" VARCHAR2(255 BYTE),
--     "SUP_COMPANY_ID"       VARCHAR2(32 BYTE),
--     "SUP_COMPANY_NAME"     VARCHAR2(255 BYTE),
--     "SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE),
--     "SUP_COMPANY_SAP_CODE" VARCHAR2(255 BYTE),
--     "SUP_COMPANY_ADDRESS"  VARCHAR2(255 BYTE),
--     "TEMPLATE_NO"          VARCHAR2(32 BYTE),
--     "TEMPLATE_NAME"        VARCHAR2(255 BYTE),
--     "TEMPLATE_LANGUAGE"    VARCHAR2(255 BYTE),
--     "TEMPLATE_DESCRIPTION" VARCHAR2(255 BYTE),
--     "APPLICATION_SCOPE"    VARCHAR2(255 BYTE),
--     "IS_VALID"             NUMBER(11),
--     "AUDIT_STATUS"         NUMBER(11),
--     "TEMPLATE_STATUS"      NUMBER(11),
--     "APPROVE_RESULT"       VARCHAR2(3500 BYTE),
--     "VERSION"              VARCHAR2(255 BYTE),
--     "TEMPLATE_TYPE"        VARCHAR2(255 BYTE),
--     "EFFECTIVE_DATE"       DATE,
--     "EXPRIATION_DATE"      DATE,
--     "PURCHASE_USER_NAME"   VARCHAR2(255 BYTE),
--     "CREATE_TIME"          DATE,
--     "UPDATE_USER_NAME"     VARCHAR2(255 BYTE),
--     "UPDATE_USER_TIME"     DATE,
--     "MARK"                 VARCHAR2(255 BYTE),
--     "IS_ENABLE"            NUMBER(11),
--     "FILE_TYPE"            VARCHAR2(255 BYTE),
--     "CONTENT_TEMPLATE"     CLOB,
--     "ATTACHMENT"           CLOB
-- );
--
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."PUR_COMPANY_ID" IS '采购商公司ID';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."PUR_COMPANY_NAME" IS '采购商公司名称';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."PUR_COMPANY_SRM_CODE" IS '采购商公司SRM编码';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."PUR_COMPANY_SAP_CODE" IS '采购商公司SAP编码';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."SUP_COMPANY_ID" IS '供应商公司ID';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."SUP_COMPANY_NAME" IS '供应商公司名称';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."SUP_COMPANY_SRM_CODE" IS '供应商公司SRM编码';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."SUP_COMPANY_ADDRESS" IS '供应商地址';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."TEMPLATE_NO" IS '模板编号';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."TEMPLATE_NAME" IS '模板名称';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."TEMPLATE_LANGUAGE" IS '模板语言';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."TEMPLATE_DESCRIPTION" IS '模板描述';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."APPLICATION_SCOPE" IS '适用范围';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."IS_VALID" IS '是否有效（有效=1，无效=0）';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."AUDIT_STATUS" IS '审批状态(未审核=1，待审核=2，审核通过=3，审核拒绝=4)';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."TEMPLATE_STATUS" IS '模板状态（新建=1，审批中=2，已发布=3，审批拒绝=4）';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."APPROVE_RESULT" IS '送审结果';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."VERSION" IS '版本';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."TEMPLATE_TYPE" IS '模板类型';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."EFFECTIVE_DATE" IS '生效日期';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."EXPRIATION_DATE" IS '失效日期';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."PURCHASE_USER_NAME" IS '创建人';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."CREATE_TIME" IS '创建时间';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."UPDATE_USER_NAME" IS '更新人';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."UPDATE_USER_TIME" IS '更新时间';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."MARK" IS '备注';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."IS_ENABLE" IS '软删除（可用=1，不可用=0）';
-- COMMENT ON COLUMN "T_CONTRACT_TEMPLATE"."FILE_TYPE" IS '文件类型';
--
--
-- ALTER TABLE "T_CONTRACT_TEMPLATE"
--     ADD PRIMARY KEY ("ID");
