
-- ----------------------------
-- 阶段划分表
-- ----------------------------
-- DROP TABLE "T_CONTRACT_STAGE_DIVISION";
CREATE TABLE "T_CONTRACT_STAGE_DIVISION" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "CONTRACT_NUM" VARCHAR2(32 BYTE) ,
  "STAGE_CODE" VARCHAR2(255 BYTE) ,
  "STAGE_NAME" VARCHAR2(255 BYTE) ,
  "PLAN_START_TIME" DATE ,
  "PLAN_END_TIME" DATE ,
  "EARLY_WARN_NOTIFIER" VARCHAR2(20 BYTE) ,
  "EARLY_WARN_NOTIFICATION_RULE" VARCHAR2(255 BYTE) ,
  "REMART" VARCHAR2(255 BYTE) ,
  "CONTRACT_ID" VARCHAR2(32 BYTE) ,
  "WARNING_DAYS" NUMBER(7) 
);

COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."ID" IS 'ID';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."PUR_COMPANY_ID" IS '公司id';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."CONTRACT_NUM" IS '合同编号';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."STAGE_CODE" IS '阶段编码';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."STAGE_NAME" IS '阶段名称';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."PLAN_START_TIME" IS '计划开始时间';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."PLAN_END_TIME" IS '计划结束时间';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."EARLY_WARN_NOTIFIER" IS '预警通知人';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."EARLY_WARN_NOTIFICATION_RULE" IS '预警通知规则';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."REMART" IS '备注';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."CONTRACT_ID" IS '合同台账ID';
COMMENT ON COLUMN "T_CONTRACT_STAGE_DIVISION"."WARNING_DAYS" IS '提前提醒天数';
COMMENT ON TABLE "T_CONTRACT_STAGE_DIVISION" IS '阶段划分表';

ALTER TABLE "T_CONTRACT_STAGE_DIVISION" ADD PRIMARY KEY ("ID");

