/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.ledger.command;

import com.els.base.contract.ledger.entity.ContractFileExample;
import com.els.base.contract.ledger.entity.StageDivisionExample;
import com.els.base.contract.ledger.entity.StagePaymentExample;
import com.els.base.contract.ledger.entity.StandingBookExample;
import com.els.base.contract.ledger.service.ContractFileService;
import com.els.base.contract.ledger.service.StageDivisionService;
import com.els.base.contract.ledger.service.StagePaymentService;
import com.els.base.contract.ledger.service.StandingBookService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.utils.SpringContextHolder;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public class StandingBookDeleteCmd
extends BaseCommand<String> {
    private List<String> ids;

    public StandingBookDeleteCmd(List<String> ids) {
        this.ids = ids;
    }

    @Transactional
    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.ids);
        this.process(this.ids);
        return null;
    }

    private void process(List<String> ids) {
        StandingBookService standingBookService = (StandingBookService)SpringContextHolder.getOneBean(StandingBookService.class);
        StagePaymentService stagePaymentService = (StagePaymentService)SpringContextHolder.getOneBean(StagePaymentService.class);
        StageDivisionService stageDivisionService = (StageDivisionService)SpringContextHolder.getOneBean(StageDivisionService.class);
        ContractFileService contractFileService = (ContractFileService)SpringContextHolder.getOneBean(ContractFileService.class);
        ContractFileExample contractFileExample = new ContractFileExample();
        contractFileExample.createCriteria().andContractIdIn((List)ids);
        contractFileService.deleteByExample((IExample)contractFileExample);
        StageDivisionExample stageDivisionExample = new StageDivisionExample();
        stageDivisionExample.createCriteria().andContractIdIn((List)ids);
        stageDivisionService.deleteByExample((IExample)stageDivisionExample);
        StagePaymentExample stagePaymentExample = new StagePaymentExample();
        stagePaymentExample.createCriteria().andContractIdIn((List)ids);
        stagePaymentService.deleteByExample((IExample)stagePaymentExample);
        StandingBookExample example = new StandingBookExample();
        example.createCriteria().andIdIn((List)ids);
        standingBookService.deleteByExample((IExample)example);
    }

    private void check(List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01");
    }
}

