/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.ledger.service.impl;

import com.els.base.contract.ledger.dao.StagePaymentMapper;
import com.els.base.contract.ledger.entity.StagePayment;
import com.els.base.contract.ledger.entity.StagePaymentExample;
import com.els.base.contract.ledger.entity.StandingBook;
import com.els.base.contract.ledger.service.StagePaymentService;
import com.els.base.contract.ledger.service.StandingBookService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultStagePaymentService")
public class StagePaymentServiceImpl
implements StagePaymentService {
    @Resource
    protected StagePaymentMapper stagePaymentMapper;
    @Resource
    protected StandingBookService standingBookService;
    @Resource
    protected UserService userService;
    private static Logger logger = LoggerFactory.getLogger(StagePaymentServiceImpl.class);
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="${mail.fromMail.addr}")
    private String from;

    @CacheEvict(value={"stagePayment"}, allEntries=true)
    public void addObj(StagePayment t) {
        this.stagePaymentMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"stagePayment"}, allEntries=true)
    public void addAll(List<StagePayment> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.stagePaymentMapper.insertBatch(list);
    }

    @CacheEvict(value={"stagePayment"}, allEntries=true)
    public void deleteObjById(String id) {
        this.stagePaymentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"stagePayment"}, allEntries=true)
    public void deleteByExample(StagePaymentExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.stagePaymentMapper.deleteByExample(example);
    }

    @CacheEvict(value={"stagePayment"}, allEntries=true)
    public void modifyObj(StagePayment t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.stagePaymentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"stagePayment"}, keyGenerator="redisKeyGenerator")
    public StagePayment queryObjById(String id) {
        return this.stagePaymentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"stagePayment"}, keyGenerator="redisKeyGenerator")
    public List<StagePayment> queryAllObjByExample(StagePaymentExample example) {
        return this.stagePaymentMapper.selectByExample(example);
    }

    @Cacheable(value={"stagePayment"}, keyGenerator="redisKeyGenerator")
    public PageView<StagePayment> queryObjByPage(StagePaymentExample example) {
        PageView<StagePayment> pageView = example.getPageView();
        pageView.setQueryResult(this.stagePaymentMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void contractStagePaymentWarn() {
        List<StagePayment> stagePayments = this.stagePaymentMapper.contractStagePaymentWarn();
        logger.info("\u67e5\u5230\u4e86" + stagePayments.size() + "\u9884\u8b66\u4fe1\u606f");
        if (null != stagePayments && stagePayments.size() > 0) {
            for (StagePayment stagePayment : stagePayments) {
                StandingBook standingBook = (StandingBook)this.standingBookService.queryObjById(stagePayment.getContractId());
                String email = "";
                if (null == standingBook || !StringUtils.isNotBlank((String)standingBook.getCreateUserId())) continue;
                User user = (User)this.userService.queryObjById((Object)standingBook.getCreateUserId());
                if (null == user || StringUtils.isBlank((String)user.getEmail())) {
                    throw new CommonException("\u6536\u4ef6\u90ae\u7bb1\u4e0d\u5b58\u5728");
                }
                email = user.getEmail();
                String subject = standingBook.getContractName() + "\u5408\u540c\u5404\u9636\u6bb5\u4ed8\u6b3e\u65f6\u95f4\u5230\u671f\u63d0\u9192";
                String messages = user.getNickName() + "\u4f60\u597d\uff0c\u91c7\u8d2d\u5e73\u53f0\u767b\u8bb0\u7684" + standingBook.getContractName() + "\u5408\u540c" + stagePayment.getPaymentStage() + "\u4ed8\u6b3e\u9636\u6bb5\u8ddd\u79bb\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4\u53ea\u6709" + stagePayment.getWarningDays() + "\u5929\uff0c\u8bf7\u8ddf\u8fdb\uff0c\u8c22\u8c22\uff01";
                this.sendEmail(email, subject, messages);
                this.sendMessageStagePaymentWarn(stagePayment, standingBook);
            }
        }
    }

    private void sendEmail(String email, String subject, String messages) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.from);
        message.setTo(email);
        message.setSubject(subject);
        message.setText(messages);
        try {
            this.mailSender.send(message);
            logger.info("\u7b80\u5355\u90ae\u4ef6\u5df2\u7ecf\u53d1\u9001\u3002");
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u7b80\u5355\u90ae\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    private void sendMessageStagePaymentWarn(StagePayment stagePayment, StandingBook standingBook) {
        String createUserId = standingBook.getCreateUserId();
        stagePayment.setCreateUserName(standingBook.getCreateUserName());
        stagePayment.setContractName(standingBook.getContractName());
        Message message = Message.init((Object)stagePayment).setCompanyCode("51000000").setBusinessTypeCode("STAGE_PAYMENT_WARN").setMsgLevel(MessageLevelEnum.HIGH).addReceiverId(createUserId);
        MessageSendUtils.sendMessage((Message)message);
    }
}

