/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.ledger.service.impl;

import com.els.base.contract.ledger.dao.StageDivisionMapper;
import com.els.base.contract.ledger.entity.StageDivision;
import com.els.base.contract.ledger.entity.StageDivisionExample;
import com.els.base.contract.ledger.entity.StandingBook;
import com.els.base.contract.ledger.service.StageDivisionService;
import com.els.base.contract.ledger.service.StandingBookService;
import com.els.base.core.entity.PageView;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultStageDivisionService")
public class StageDivisionServiceImpl
implements StageDivisionService {
    @Resource
    protected StageDivisionMapper stageDivisionMapper;
    @Resource
    protected StandingBookService standingBookService;
    @Resource
    protected UserService userService;
    @Value(value="${mail.fromMail.addr}")
    private String from;
    private static Logger logger = LoggerFactory.getLogger(StageDivisionServiceImpl.class);

    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void addObj(StageDivision t) {
        this.stageDivisionMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void addAll(List<StageDivision> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.stageDivisionMapper.insertBatch(list);
    }

    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void deleteObjById(String id) {
        this.stageDivisionMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void deleteByExample(StageDivisionExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.stageDivisionMapper.deleteByExample(example);
    }

    @CacheEvict(value={"stageDivision"}, allEntries=true)
    public void modifyObj(StageDivision t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.stageDivisionMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"stageDivision"}, keyGenerator="redisKeyGenerator")
    public StageDivision queryObjById(String id) {
        return this.stageDivisionMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"stageDivision"}, keyGenerator="redisKeyGenerator")
    public List<StageDivision> queryAllObjByExample(StageDivisionExample example) {
        return this.stageDivisionMapper.selectByExample(example);
    }

    @Cacheable(value={"stageDivision"}, keyGenerator="redisKeyGenerator")
    public PageView<StageDivision> queryObjByPage(StageDivisionExample example) {
        PageView<StageDivision> pageView = example.getPageView();
        pageView.setQueryResult(this.stageDivisionMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void contractWarn() {
        List<StageDivision> stageDivisions = this.stageDivisionMapper.stageDivisionWarn();
        logger.info("\u67e5\u8be2\u5230\u6709" + stageDivisions.size() + "\u6761\u5408\u540c\u9884\u8b66");
        if (null != stageDivisions && stageDivisions.size() > 0) {
            for (StageDivision stageDivision : stageDivisions) {
                String contractId = stageDivision.getContractId();
                Optional.ofNullable(this.standingBookService.queryObjById(contractId)).ifPresent(standingBook -> this.sendMessageStageDivisionWarn(stageDivision, (StandingBook)standingBook));
            }
        }
    }

    private void sendMessageStageDivisionWarn(StageDivision stageDivision, StandingBook standingBook) {
        String createUserId = standingBook.getCreateUserId();
        stageDivision.setCreateUserName(standingBook.getCreateUserName());
        stageDivision.setContractName(standingBook.getContractName());
        Message message = Message.init((Object)stageDivision).setCompanyCode("51000000").setBusinessTypeCode("STAGE_DIVISION_WARN").setMsgLevel(MessageLevelEnum.HIGH).addReceiverId(createUserId);
        MessageSendUtils.sendMessage((Message)message);
    }
}

