/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.contract.ledger.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.contract.ledger.command.StandingBookAddCmd;
import com.els.base.contract.ledger.command.StandingBookDeleteCmd;
import com.els.base.contract.ledger.command.StandingBookUpdateCmd;
import com.els.base.contract.ledger.entity.ContractFileExample;
import com.els.base.contract.ledger.entity.StageDivisionExample;
import com.els.base.contract.ledger.entity.StagePaymentExample;
import com.els.base.contract.ledger.entity.StandingBook;
import com.els.base.contract.ledger.entity.StandingBookExample;
import com.els.base.contract.ledger.service.ContractFileService;
import com.els.base.contract.ledger.service.StageDivisionService;
import com.els.base.contract.ledger.service.StagePaymentService;
import com.els.base.contract.ledger.service.StandingBookService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u5408\u540c\u53f0\u8d26\u8868"})
@Controller
@RequestMapping(value={"standingBook"})
public class StandingBookController {
    @Resource
    protected StandingBookService standingBookService;
    @Resource
    protected StageDivisionService stageDivisionService;
    @Resource
    protected StagePaymentService stagePaymentService;
    @Resource
    protected ContractFileService contractFileService;
    @Resource
    protected ICommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5408\u540c\u53f0\u8d26\u8868")
    @RequestMapping(value={"service/create", "service/createStandBook"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody StandingBook standingBook) {
        standingBook.setCreateUserName(SpringSecurityUtils.getLoginUserName());
        standingBook.setCreateUserId(SpringSecurityUtils.getLoginUserId());
        standingBook.setProjectId(ProjectUtils.getProjectId());
        standingBook.setPurCompanyId(CompanyUtils.currentCompanyId());
        StandingBookAddCmd cmd = new StandingBookAddCmd(standingBook);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success((Object)standingBook.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5408\u540c\u53f0\u8d26\u8868")
    @RequestMapping(value={"service/edit", "service/updStandBook"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody StandingBook standingBook) {
        standingBook.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        standingBook.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        standingBook.setProjectId(ProjectUtils.getProjectId());
        standingBook.setPurCompanyId(CompanyUtils.currentCompanyId());
        StandingBookUpdateCmd cmd = new StandingBookUpdateCmd(standingBook);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5408\u540c\u53f0\u8be6\u60c5")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<StandingBook> findById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        StandingBook standingBook = (StandingBook)this.standingBookService.queryObjById(id);
        Assert.isNotNull((Object)standingBook, (String)"\u5408\u540c\u53f0\u8d26\u4e0d\u5b58\u5728\uff01");
        StageDivisionExample stageDivisionExample = new StageDivisionExample();
        stageDivisionExample.createCriteria().andContractIdEqualTo(id);
        List stageDivisions = this.stageDivisionService.queryAllObjByExample((IExample)stageDivisionExample);
        standingBook.setDivisions(stageDivisions);
        StagePaymentExample stagePaymentExample = new StagePaymentExample();
        stagePaymentExample.createCriteria().andContractIdEqualTo(id);
        List stagePaymentList = this.stagePaymentService.queryAllObjByExample((IExample)stagePaymentExample);
        standingBook.setPayments(stagePaymentList);
        ContractFileExample contractFileExample = new ContractFileExample();
        contractFileExample.createCriteria().andContractIdEqualTo(id);
        List contractFileList = this.contractFileService.queryAllObjByExample((IExample)contractFileExample);
        standingBook.setContractFileList(contractFileList);
        return ResponseResult.success((Object)standingBook);
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5408\u540c\u53f0\u8d26\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        StandingBookDeleteCmd cmd = new StandingBookDeleteCmd(ids);
        this.invoker.invoke((BaseCommand)cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5408\u540c\u53f0\u8d26\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 StandingBook", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<StandingBook>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        StandingBookExample example = new StandingBookExample();
        example.setPageView((PageView<StandingBook>)new PageView(pageNo, pageSize));
        StandingBookExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        criteria.andCreateUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        PageView pageData = this.standingBookService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

