
-- ----------------------------
-- 合同台账表
-- ----------------------------
-- DROP TABLE "T_CONTRACT_STANDING_BOOK";
CREATE TABLE "T_CONTRACT_STANDING_BOOK" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) ,
  "PUR_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "CONTRACT_NUM" VARCHAR2(32 BYTE) ,
  "CONTRACT_NAME" VARCHAR2(32 BYTE) ,
  "CONTRACT_TYPE" VARCHAR2(32 BYTE) ,
  "SUP_NAME" VARCHAR2(50 BYTE) ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) ,
  "CONTRACT_STATUS" NUMBER(2) ,
  "CONTRACT_VERSION" VARCHAR2(50 BYTE) ,
  "EFFECTIVE_TIME" DATE ,
  "FAILURE_TIME" DATE ,
  "CONTRACT_ADMIN" VARCHAR2(20 BYTE) ,
  "INSTITUTION_NAME" VARCHAR2(50 BYTE) ,
  "CONTRACT_EXPLAIN" VARCHAR2(255 BYTE) ,
  "CONTRACT_AMOUNT" NUMBER(15,2) ,
  "FILE_NAME" VARCHAR2(300 BYTE) ,
  "FILE_URL" VARCHAR2(255 BYTE) ,
  "CREATE_TIME" DATE ,
  "CREATE_USER_ID" VARCHAR2(32 BYTE) ,
  "UPDATE_TIME" DATE ,
  "UPDATE_USER_NAME" DATE ,
  "UPDATE_USER_ID" VARCHAR2(32 BYTE) ,
  "CREATE_USER_NAME" VARCHAR2(255 BYTE) ,
  "CONTRACT_NO" VARCHAR2(32 BYTE) ,
  "REMART" VARCHAR2(255 BYTE) 
);

COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."ID" IS 'ID';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."PUR_COMPANY_ID" IS '公司id';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CONTRACT_NUM" IS '合同编号';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CONTRACT_NAME" IS '合同名称';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CONTRACT_TYPE" IS '合同类型';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."SUP_NAME" IS '供应商名称';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."SUP_COMPANY_ID" IS '供应商';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CONTRACT_STATUS" IS '合同状态';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CONTRACT_VERSION" IS '版本';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."EFFECTIVE_TIME" IS '生效日期';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."FAILURE_TIME" IS '失效日期';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CONTRACT_ADMIN" IS '合同管理员';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."INSTITUTION_NAME" IS '机构名称';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CONTRACT_EXPLAIN" IS '合同说明';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CONTRACT_AMOUNT" IS '合同金额';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."FILE_NAME" IS '附件名称（多个以，分割）';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."FILE_URL" IS '附件下载url（多个以，分割）';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CREATE_USER_ID" IS '创建人id';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."UPDATE_USER_NAME" IS '更新人';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."UPDATE_USER_ID" IS '更新人id';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CREATE_USER_NAME" IS '创建人';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."CONTRACT_NO" IS '合同流水号';
COMMENT ON COLUMN "T_CONTRACT_STANDING_BOOK"."REMART" IS '备注';
COMMENT ON TABLE "T_CONTRACT_STANDING_BOOK" IS '合同台账表';


ALTER TABLE "T_CONTRACT_STANDING_BOOK" ADD  PRIMARY KEY ("ID");

