package com.els.base.file.entity;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;

import com.els.base.utils.SpringContextHolder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="文件表")
public class FileData implements Serializable {
	
//	###########以下添加内容，请勿覆盖#######################
	
	public File toFile(){
		Properties properties = SpringContextHolder.getBean("sysConfig");
		String location = properties.getProperty("resource.location", ""); //
		File file = new File(location + "/" + this.getLocalRelatPath() + this.getFileRename());
		return file;
	}
	
//	##################################
	
	@ApiModelProperty("主键")
	private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("公司ID")
    private String companyId;

    @ApiModelProperty("用户ID")
    private String userId;

    @ApiModelProperty("附件名称")
    private String fileName;

    @ApiModelProperty("文件重命名")
    private String fileRename;

    @ApiModelProperty("文件后缀")
    private String fileSuffix;

    @ApiModelProperty("文件大小，单位是字节")
    private Integer fileSize;

    @ApiModelProperty("文件连接路径")
    private String fileUrl;

    @ApiModelProperty("是否加密,1加密、0不加密")
    private String isEncrypt;

    @ApiModelProperty("是否加密上传文件的密钥")
    private String encryptKey;

    @ApiModelProperty("文件保存的目标地，1本地保存，2阿里云保存，3亚马逊云保存")
    private Integer saveType;

    @ApiModelProperty("本地保存的相对路径")
    private String localRelatPath;

    @ApiModelProperty("上传时间")
    private Date createTime;

    @ApiModelProperty("过期时间")
    private Date expiryDay;

    @ApiModelProperty("文件来源")
    private String sourceType;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId == null ? null : userId.trim();
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName == null ? null : fileName.trim();
    }

    public String getFileRename() {
        return fileRename;
    }

    public void setFileRename(String fileRename) {
        this.fileRename = fileRename == null ? null : fileRename.trim();
    }

    public String getFileSuffix() {
        return fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix == null ? null : fileSuffix.trim();
    }

    public Integer getFileSize() {
        return fileSize;
    }

    public void setFileSize(Integer fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl == null ? null : fileUrl.trim();
    }

    public String getIsEncrypt() {
        return isEncrypt;
    }

    public void setIsEncrypt(String isEncrypt) {
        this.isEncrypt = isEncrypt == null ? null : isEncrypt.trim();
    }

    public String getEncryptKey() {
        return encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey == null ? null : encryptKey.trim();
    }

    public Integer getSaveType() {
        return saveType;
    }

    public void setSaveType(Integer saveType) {
        this.saveType = saveType;
    }

    public String getLocalRelatPath() {
        return localRelatPath;
    }

    public void setLocalRelatPath(String localRelatPath) {
        this.localRelatPath = localRelatPath == null ? null : localRelatPath.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getExpiryDay() {
        return expiryDay;
    }

    public void setExpiryDay(Date expiryDay) {
        this.expiryDay = expiryDay;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType == null ? null : sourceType.trim();
    }
}