package com.els.base.file.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileDataService;
import com.els.base.file.service.IFileManager;
import com.els.base.file.utils.FileSaveTypeEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;

public class OssFileManager implements IFileManager{
	private static Logger logger = LoggerFactory.getLogger(OssFileManager.class);

	private static String accessKeyId; 
	private static String accessKeySecret;
	private static String endPoint;  //访问区域
	private static String bucketName;  //存储空间名
    private OSSClient client;
    private ObjectMetadata metadata = new ObjectMetadata();
    private static String keyName;  // 上传对象的唯一标识,这里用上文对象的名称来做唯一标识
    
	private static FileDataService fileDataService = SpringContextHolder.getOneBean(FileDataService.class);

	@Override
	public FileData write(InputStream in, FileData fileData) throws IOException {
		logger.info("此方法暂时未开发！");
		return null;
	}

	@Override
	public FileData write(File file, FileData fileData) throws IOException {
		logger.info("此方法暂时未开发！");
		return null;
	}

	@Override
	public FileData write(MultipartFile multfile, FileData fileData) throws IOException {
		String isEncrypt = fileData.getIsEncrypt();
		if(Integer.parseInt(isEncrypt)==Constant.YES_INT){
			//通知oss服务端对文件加密
			metadata.setHeader("x-oss-server-side-encryption", "AES256");
		}else{
			metadata = new ObjectMetadata();
		}

        fileData.setId(UUIDGenerator.generateUUID());
		fileData.setFileName(multfile.getOriginalFilename());
		fileData.setFileSize(Long.valueOf(multfile.getSize()).intValue());
		fileData.setSaveType(FileSaveTypeEnum.OSS.getSaveType());
				
        //上传文件服务端加密
		PutObjectResult objectResult = serverSideEncryptionPutObject(multfile);
		
		if(objectResult != null){//上传到OSS平台成功
			// 文件信息保存到表里
	     	fileDataService.addObj(fileData);
		}

		return fileData;
	}

	/**
     * 服务端加密上传
	 * @throws IOException 
     */
    private PutObjectResult serverSideEncryptionPutObject(MultipartFile multfile) throws IOException {
    	// 文件名称
    	keyName = multfile.getOriginalFilename();
    	PutObjectResult result = uploadObject(multfile.getInputStream());
        return result;
    }
	
    private PutObjectResult uploadObject(InputStream file) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, keyName, file, metadata);
        PutObjectResult result = client.putObject(putObjectRequest);
        return result;
    }
    
	@Override
	public InputStream read(FileData fileData) {
		keyName = fileData.getFileName();
        // 下载文件
        return downloadObject();
    }

	private InputStream downloadObject() {
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, keyName);
        OSSObject oSSObject = client.getObject(getObjectRequest);
        return oSSObject.getObjectContent();
    }
	@Transactional
	@Override
	public void remove(FileData fileData) {
		String fileId = fileData.getId();
		fileDataService.deleteObjById(fileId);		
		keyName = fileData.getFileName();
		GenericRequest genericRequest = new GenericRequest(bucketName, keyName);
		client.deleteObject(genericRequest);
	}

	@Override
	public boolean isExist(FileData fileData) {
		logger.info("此方法暂时未开发！");
		return true;
	}

	@Override
	public void init() {
		Properties sysConfig = SpringContextHolder.getBean("sysConfig");
		endPoint = sysConfig.getProperty("oss.endpoint");
		bucketName = sysConfig.getProperty("oss.bucketName");
		accessKeyId = sysConfig.getProperty("oss.accessKeyId");
		accessKeySecret = sysConfig.getProperty("oss.accessKeySecret");

		if (StringUtils.isBlank(endPoint) || StringUtils.isBlank(bucketName) || StringUtils.isBlank(accessKeyId)
				|| StringUtils.isBlank(accessKeySecret)) {
			logger.warn(
					"阿里云服务启用失败,缺乏配置。 aws.oss.endpoint[{0}],oss.bucketName[{1}],oss.accessKeyId[{2}],oss.accessKeySecret[{3}]",
					new String[] { endPoint, bucketName, accessKeyId, accessKeySecret});
			return;
		}

		client = new OSSClient(endPoint, accessKeyId, accessKeySecret);
	}

	@Override
	public OutputStream createOutputStream(FileData fileData) throws IOException {
		logger.info("此方法暂时未开发！");
		return null;
	}

	@Override
	public File createEmptyFile(FileData fileData) {
		logger.info("此方法暂时未开发！");
		return null;
	}

}
