package com.els.base.file.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.els.base.file.entity.FileData;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 支持前端vue的上传组件，特定的反序列化
 * @author hzy
 *
 */
public class UploadSupportJsonDeserializer extends JsonDeserializer<String> {

	@Override
	public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
		ArrayNode arrayNode = p.readValueAsTree();
		if (arrayNode == null) {
			return null;
		}
		
		List<FileData> fileDatas = new ArrayList<>();
		for(int i=0; i<arrayNode.size(); i++){
			ObjectNode node = (ObjectNode) arrayNode.get(i);
			FileData fileData = new FileData();
			fileData.setCompanyId(node.get("companyId").asText());
//			fileData.setEncryptKey(node.get("encryptKey").asText());
			fileData.setFileName(node.get("name").asText());
			fileData.setFileSize(node.get("fileSize").asInt());
			fileData.setFileRename(node.get("fileRename").asText());
			fileData.setFileSuffix(node.get("fileSuffix").asText());
			fileData.setFileUrl(node.get("url").asText());
			fileData.setId(node.get("id").asText());
//			fileData.setIsEncrypt(node.get("isEncrypt").asText());
//			fileData.setLocalRelatPath(node.get("localRelatPath").asText());
			fileData.setProjectId(node.get("projectId").asText());
			fileData.setSaveType(node.get("saveType").asInt());
			fileData.setUserId(node.get("userId").asText());
			
			fileDatas.add(fileData);
		}
		
		return JsonUtils.writeValueAsString(fileDatas);
	}

}
