package com.els.base.file.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.file.entity.FileData;
import com.els.base.file.web.controller.vo.FileDataJson;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * 支持前端vue的上传组件，特定的序列化
 * @author hzy
 *
 */
public class UploadSupportJsonSerializer extends JsonSerializer<String> {

	@Override
	public void serialize(String value, JsonGenerator gen, SerializerProvider serializers)
			throws IOException, JsonProcessingException {
		if (StringUtils.isBlank(value)) {
			gen.writeString("");
		}
		
		List<FileDataJson> fileDataJsons = new ArrayList<>();
		
		List<FileData> fileDatas = JsonUtils.convertCollection(value, List.class, null, FileData.class);
		for(int i=0; CollectionUtils.isNotEmpty(fileDatas) && i<fileDatas.size(); i++){
			FileDataJson fileDataJson = new FileDataJson();
			try {
				BeanUtils.copyProperties(fileDataJson, fileDatas.get(i));
			} catch (Exception e) {
				e.printStackTrace();
				throw new CommonException("上传文件序列化失败");
			}
			fileDataJsons.add(fileDataJson);
		}
		
		gen.writeStartArray();
		
		for(int i=0; CollectionUtils.isNotEmpty(fileDataJsons) && i<fileDataJsons.size(); i++){
			gen.writeObject(fileDataJsons.get(i));
		}
		
		gen.writeEndArray();
	}
	
}
