/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.file.service.impl;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileDataService;
import com.els.base.file.service.IFileManager;
import com.els.base.file.utils.FileSaveTypeEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

public class OssFileManager
implements IFileManager {
    private static Logger logger = LoggerFactory.getLogger(OssFileManager.class);
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String endPoint;
    private static String bucketName;
    private OSSClient client;
    private ObjectMetadata metadata = new ObjectMetadata();
    private static String keyName;
    private static FileDataService fileDataService;

    @Override
    public FileData write(InputStream in, FileData fileData) throws IOException {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return null;
    }

    @Override
    public FileData write(File file, FileData fileData) throws IOException {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return null;
    }

    @Override
    public FileData write(MultipartFile multfile, FileData fileData) throws IOException {
        String isEncrypt = fileData.getIsEncrypt();
        if (Integer.parseInt(isEncrypt) == Constant.YES_INT) {
            this.metadata.setHeader("x-oss-server-side-encryption", (Object)"AES256");
        } else {
            this.metadata = new ObjectMetadata();
        }
        fileData.setId(UUIDGenerator.generateUUID());
        fileData.setFileName(multfile.getOriginalFilename());
        fileData.setFileSize(Long.valueOf(multfile.getSize()).intValue());
        fileData.setSaveType(FileSaveTypeEnum.OSS.getSaveType());
        PutObjectResult objectResult = this.serverSideEncryptionPutObject(multfile);
        if (objectResult != null) {
            fileDataService.addObj(fileData);
        }
        return fileData;
    }

    private PutObjectResult serverSideEncryptionPutObject(MultipartFile multfile) throws IOException {
        keyName = multfile.getOriginalFilename();
        PutObjectResult result = this.uploadObject(multfile.getInputStream());
        return result;
    }

    private PutObjectResult uploadObject(InputStream file) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, keyName, file, this.metadata);
        PutObjectResult result = this.client.putObject(putObjectRequest);
        return result;
    }

    @Override
    public InputStream read(FileData fileData) {
        keyName = fileData.getFileName();
        return this.downloadObject();
    }

    private InputStream downloadObject() {
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, keyName);
        OSSObject oSSObject = this.client.getObject(getObjectRequest);
        return oSSObject.getObjectContent();
    }

    @Override
    @Transactional
    public void remove(FileData fileData) {
        String fileId = fileData.getId();
        fileDataService.deleteObjById(fileId);
        keyName = fileData.getFileName();
        GenericRequest genericRequest = new GenericRequest(bucketName, keyName);
        this.client.deleteObject(genericRequest);
    }

    @Override
    public boolean isExist(FileData fileData) {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return true;
    }

    @Override
    public void init() {
        Properties sysConfig = (Properties)SpringContextHolder.getBean((String)"sysConfig");
        endPoint = sysConfig.getProperty("oss.endpoint");
        bucketName = sysConfig.getProperty("oss.bucketName");
        accessKeyId = sysConfig.getProperty("oss.accessKeyId");
        accessKeySecret = sysConfig.getProperty("oss.accessKeySecret");
        if (StringUtils.isBlank((String)endPoint) || StringUtils.isBlank((String)bucketName) || StringUtils.isBlank((String)accessKeyId) || StringUtils.isBlank((String)accessKeySecret)) {
            logger.warn("\u963f\u91cc\u4e91\u670d\u52a1\u542f\u7528\u5931\u8d25,\u7f3a\u4e4f\u914d\u7f6e\u3002 aws.oss.endpoint[{0}],oss.bucketName[{1}],oss.accessKeyId[{2}],oss.accessKeySecret[{3}]", (Object[])new String[]{endPoint, bucketName, accessKeyId, accessKeySecret});
            return;
        }
        this.client = new OSSClient(endPoint, accessKeyId, accessKeySecret);
    }

    @Override
    public OutputStream createOutputStream(FileData fileData) throws IOException {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return null;
    }

    @Override
    public File createEmptyFile(FileData fileData) {
        logger.info("\u6b64\u65b9\u6cd5\u6682\u65f6\u672a\u5f00\u53d1\uff01");
        return null;
    }

    static {
        fileDataService = (FileDataService)SpringContextHolder.getOneBean(FileDataService.class);
    }
}

